/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.postag;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.tools.postag.POSEventStream;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.DataStreamBuilder;
import opennlp.uima.util.CasConsumerUtil;
import opennlp.uima.util.ContainingConstraint;
import opennlp.uima.util.OpennlpUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

public class POSTaggerTrainer
extends CasConsumer_ImplBase {
    private UimaContext mContext;
    private Type mSentenceType;
    private Type mTokenType;
    private String mModelName;
    private Feature mPOSFeature;
    private Logger mLogger;
    private DataStreamBuilder mPOSEvents;

    public void initialize() throws ResourceInitializationException {
        this.mContext = this.getUimaContext();
        this.mLogger = this.mContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP POSTagger trainer.");
        }
        this.mPOSEvents = new DataStreamBuilder();
        this.mModelName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.MODEL_PARAMETER);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        String sentenceTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.SENTENCE_TYPE_PARAMETER);
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, UimaUtil.SENTENCE_TYPE_PARAMETER + ": " + sentenceTypeName);
        }
        this.mSentenceType = CasConsumerUtil.getType(typeSystem, sentenceTypeName);
        String tokenTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.TokenType");
        this.mTokenType = CasConsumerUtil.getType(typeSystem, tokenTypeName);
        String posFeatureName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.POSFeature");
        this.mPOSFeature = this.mTokenType.getFeatureByBaseName(posFeatureName);
    }

    public void processCas(CAS cas) {
        AnnotationIndex<AnnotationFS> sentenceAnnotations = cas.getAnnotationIndex(this.mSentenceType);
        for (AnnotationFS sentence : sentenceAnnotations) {
            this.process(cas, sentence);
        }
    }

    private void process(CAS tcas, AnnotationFS sentence) {
        AnnotationIndex<AnnotationFS> allTokens = tcas.getAnnotationIndex(this.mTokenType);
        ContainingConstraint containingConstraint = new ContainingConstraint(sentence);
        FSIterator containingTokens = tcas.createFilteredIterator(allTokens.iterator(), containingConstraint);
        StringBuilder sentenceEvent = new StringBuilder();
        while (containingTokens.hasNext()) {
            AnnotationFS tokenAnnotation = (AnnotationFS)containingTokens.next();
            String tag = tokenAnnotation.getFeatureValueAsString(this.mPOSFeature);
            sentenceEvent.append(tokenAnnotation.getCoveredText().trim());
            sentenceEvent.append('_');
            sentenceEvent.append(tag);
            boolean isLastElement = !containingTokens.hasNext();
            if (isLastElement) continue;
            sentenceEvent.append(' ');
        }
        this.mPOSEvents.add(sentenceEvent.toString());
    }

    public void collectionProcessComplete(ProcessTrace trace) throws ResourceProcessException, IOException {
        GIS.PRINT_MESSAGES = false;
        GISModel posTaggerModel = POSTaggerME.train(new POSEventStream(this.mPOSEvents), 100, 5);
        this.mPOSEvents = null;
        File modelFile = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + this.mModelName);
        OpennlpUtil.serialize(posTaggerModel, new FileOutputStream(modelFile));
    }

    public boolean isStateless() {
        return false;
    }

    public void destroy() {
        this.mPOSEvents = null;
    }
}

