/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.normalizer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import opennlp.tools.dictionary.serializer.Attributes;
import opennlp.tools.dictionary.serializer.DictionarySerializer;
import opennlp.tools.dictionary.serializer.Entry;
import opennlp.tools.dictionary.serializer.EntryInserter;
import opennlp.tools.ngram.TokenList;
import opennlp.tools.util.InvalidFormatException;

public class StringDictionary {
    private Map entries = new HashMap();

    public StringDictionary() {
    }

    public StringDictionary(InputStream in) throws IOException, InvalidFormatException {
        DictionarySerializer.create(in, new EntryInserter(){

            public void insert(Entry entry) throws InvalidFormatException {
                String valueString = entry.getAttributes().getValue("value");
                StringDictionary.this.put(entry.getTokens(), valueString);
            }
        });
    }

    public String get(TokenList key) {
        return (String)this.entries.get(key);
    }

    public void put(TokenList key, String value2) {
        this.entries.put(key, value2);
    }

    Iterator iterator() {
        return this.entries.keySet().iterator();
    }

    public void serialize(OutputStream out) throws IOException {
        Iterator entryIterator = new Iterator(){
            private Iterator mDictionaryIterator;
            {
                this.mDictionaryIterator = StringDictionary.this.iterator();
            }

            public boolean hasNext() {
                return this.mDictionaryIterator.hasNext();
            }

            public Object next() {
                TokenList tokens = (TokenList)this.mDictionaryIterator.next();
                Attributes attributes = new Attributes();
                attributes.setValue("value", StringDictionary.this.get(tokens));
                return new Entry(tokens, attributes);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionarySerializer.serialize(out, entryIterator);
    }
}

