/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.normalizer;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public final class NumberUtil {
    public static boolean isLanguageSupported(String languageCode) {
        Locale locale = new Locale(languageCode);
        Locale[] possibleLocales = NumberFormat.getAvailableLocales();
        boolean isLocaleSupported = false;
        for (int i = 0; i < possibleLocales.length; ++i) {
            if (!possibleLocales[i].equals(locale)) continue;
            isLocaleSupported = true;
            break;
        }
        return isLocaleSupported;
    }

    private static String removeChar(String string2, char remove) {
        StringBuilder result2 = new StringBuilder();
        int lastPosition = 0;
        int position = 0;
        while ((position = string2.indexOf(remove, lastPosition)) != -1) {
            result2.append(string2.substring(lastPosition, position));
            lastPosition = position + 1;
        }
        result2.append(string2.substring(lastPosition, string2.length()));
        return result2.toString();
    }

    public static Number parse(String number2, String languageCode) throws ParseException {
        if (!NumberUtil.isLanguageSupported(languageCode)) {
            throw new IllegalArgumentException("Language is not supported!");
        }
        Locale locale = new Locale(languageCode);
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        number2 = number2.trim();
        number2 = NumberUtil.removeChar(number2, ' ');
        return numberFormat.parse(number2);
    }
}

