/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.namefind;

import java.util.ArrayList;
import java.util.List;
import opennlp.maxent.MaxentModel;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.namefind.AdaptiveFeatureGenerator;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.DictionaryFeatureGenerator;
import opennlp.tools.namefind.DictionaryNameFinder;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenClassFeatureGenerator;
import opennlp.tools.namefind.TokenFeatureGenerator;
import opennlp.tools.namefind.TokenPatternFeatureGenerator;
import opennlp.tools.namefind.WindowFeatureGenerator;
import opennlp.tools.util.Span;
import opennlp.uima.namefind.AbstractNameFinder;
import opennlp.uima.namefind.NameFinderTrainer;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.Mean;
import opennlp.uima.util.OpennlpUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;

public final class NameFinder
extends AbstractNameFinder {
    public static final String NAME_TYPE_PARAMETER = "opennlp.uima.NameType";
    static final String DICTIONARY_PARAMETER = "opennlp.uima.Dictionary";
    static final String TOKEN_PATTERN_OPTIMIZATION = "opennlp.uima.TokenPatternOptimization";
    static final String TOKEN_FEATURE_PARAMETER = "opennlp.uima.namefinder.TokenFeature";
    static final String TOKEN_FEATURE_PREV_WINDOW_SIZE_PARAMETER = "opennlp.uima.namefinder.TokenFeature.previousWindowSize";
    static final String TOKEN_FEATURE_NEXT_WINDOW_SIZE_PARAMETER = "opennlp.uima.namefinder.TokenFeature.nextWindowSize";
    static final String TOKEN_CLASS_FEATURE_PARAMETER = "opennlp.uima.namefinder.TokenClassFeature";
    static final String TOKEN_CLASS_FEATURE_PREV_WINDOW_SIZE_PARAMETER = "opennlp.uima.namefinder.TokenClassFeature.previousWindowSize";
    static final String TOKEN_CLASS_FEATURE_NEXT_WINDOW_SIZE_PARAMETER = "opennlp.uima.namefinder.TokenClassFeature.nextWindowSize";
    private NameFinderME mNameFinder;
    private Type[] additonalContextTypes;
    private Feature probabilityFeature;
    private Type documentConfidenceType;
    private Feature documentConfidenceNameTypeFeature;
    private Feature documentConfidenceFeature;
    private Mean documentConfidence = new Mean();

    public NameFinder() {
        super("OpenNLP Maxent Name annotator");
    }

    public void initialize() throws ResourceInitializationException {
        Boolean tokenPatternSupport;
        Dictionary nameDictionary;
        Boolean isTokenClassFeatureGenertorEnabled;
        MaxentModel nameFinderModel = OpennlpUtil.createModel(this.context, UimaUtil.MODEL_PARAMETER);
        Integer beamSize = AnnotatorUtil.getOptionalIntegerParameter(this.context, "opennlp.uima.BeamSize");
        ArrayList<AdaptiveFeatureGenerator> generators = new ArrayList<AdaptiveFeatureGenerator>();
        Boolean isTokenFeatureGeneratorEnabled = AnnotatorUtil.getOptionalBooleanParameter(this.context, TOKEN_FEATURE_PARAMETER);
        if (isTokenFeatureGeneratorEnabled == null) {
            isTokenFeatureGeneratorEnabled = Boolean.TRUE;
        }
        if (isTokenFeatureGeneratorEnabled.booleanValue()) {
            Integer nextWindowSize;
            Integer prevWindowSize = AnnotatorUtil.getOptionalIntegerParameter(this.context, TOKEN_FEATURE_PREV_WINDOW_SIZE_PARAMETER);
            if (prevWindowSize == null) {
                prevWindowSize = new Integer(5);
            }
            if ((nextWindowSize = AnnotatorUtil.getOptionalIntegerParameter(this.context, TOKEN_FEATURE_NEXT_WINDOW_SIZE_PARAMETER)) == null) {
                nextWindowSize = new Integer(5);
            }
            generators.add(new WindowFeatureGenerator(new TokenFeatureGenerator(), prevWindowSize, nextWindowSize));
        }
        if ((isTokenClassFeatureGenertorEnabled = AnnotatorUtil.getOptionalBooleanParameter(this.context, TOKEN_CLASS_FEATURE_PARAMETER)) == null) {
            isTokenClassFeatureGenertorEnabled = Boolean.TRUE;
        }
        if (isTokenClassFeatureGenertorEnabled.booleanValue()) {
            Integer nextWindowSize;
            Integer prevWindowSize = AnnotatorUtil.getOptionalIntegerParameter(this.context, TOKEN_CLASS_FEATURE_PREV_WINDOW_SIZE_PARAMETER);
            if (prevWindowSize == null) {
                prevWindowSize = new Integer(3);
            }
            if ((nextWindowSize = AnnotatorUtil.getOptionalIntegerParameter(this.context, TOKEN_CLASS_FEATURE_NEXT_WINDOW_SIZE_PARAMETER)) == null) {
                nextWindowSize = new Integer(3);
            }
            generators.add(new WindowFeatureGenerator(new TokenClassFeatureGenerator(), prevWindowSize, nextWindowSize));
        }
        if ((nameDictionary = AnnotatorUtil.createOptionalDictionary(this.context, DICTIONARY_PARAMETER)) != null) {
            generators.add(new DictionaryFeatureGenerator(new DictionaryNameFinder(nameDictionary)));
        }
        if ((tokenPatternSupport = AnnotatorUtil.getOptionalBooleanParameter(this.context, TOKEN_PATTERN_OPTIMIZATION)) != null) {
            generators.add(new TokenPatternFeatureGenerator());
        }
        DefaultNameContextGenerator contextGenerator = new DefaultNameContextGenerator(generators.toArray(new AdaptiveFeatureGenerator[generators.size()]));
        this.mNameFinder = beamSize != null ? new NameFinderME(nameFinderModel, contextGenerator, beamSize) : new NameFinderME(nameFinderModel, contextGenerator);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        String[] additionaContextTypeStrings;
        super.typeSystemInit(typeSystem);
        try {
            additionaContextTypeStrings = AnnotatorUtil.getOptionalStringArrayParameter(this.context, "opennlp.uima.AdditionalContextType");
        }
        catch (ResourceInitializationException e) {
            throw new AnalysisEngineProcessException(e);
        }
        this.additonalContextTypes = new Type[additionaContextTypeStrings.length];
        for (int i = 0; i < additionaContextTypeStrings.length; ++i) {
            this.additonalContextTypes[i] = typeSystem.getType(additionaContextTypeStrings[i]);
        }
        this.probabilityFeature = AnnotatorUtil.getOptinoalFeatureParameter(this.context, this.mNameType, "opennlp.uima.ProbabilityFeature", "uima.cas.Double");
        this.documentConfidenceType = AnnotatorUtil.getOptionalTypeParameter(this.context, typeSystem, "opennlp.uima.DocumentConfidenceType");
        if (this.documentConfidenceType != null) {
            this.documentConfidenceNameTypeFeature = AnnotatorUtil.getRequiredFeature(this.documentConfidenceType, "nameType");
            this.documentConfidenceFeature = AnnotatorUtil.getRequiredFeature(this.documentConfidenceType, "confidence");
        }
    }

    protected Span[] find(CAS cas, AnnotationFS sentence, List tokenAnnotations, String[] tokens) {
        String[][] context = NameFinderTrainer.createAdditioinalConextUima(cas, sentence, tokenAnnotations, this.additonalContextTypes);
        Span[] names = this.mNameFinder.find(tokens, context);
        double[] probs = this.mNameFinder.probs();
        for (int i = 0; i < probs.length; ++i) {
            this.documentConfidence.add(probs[i]);
        }
        return names;
    }

    protected void postProcessAnnotations(Span[] detectedNames, AnnotationFS[] nameAnnotations) {
        if (this.probabilityFeature != null) {
            double[] probs = this.mNameFinder.probs(detectedNames);
            for (int i = 0; i < nameAnnotations.length; ++i) {
                nameAnnotations[i].setDoubleValue(this.probabilityFeature, probs[i]);
            }
        }
    }

    protected void documentDone(CAS cas) {
        if (this.documentConfidenceType != null) {
            FeatureStructure confidenceFS = cas.createFS(this.documentConfidenceType);
            confidenceFS.setDoubleValue(this.documentConfidenceFeature, this.documentConfidence.mean());
            confidenceFS.setStringValue(this.documentConfidenceNameTypeFeature, this.mNameType.getName());
            cas.addFsToIndexes(confidenceFS);
        }
        this.mNameFinder.clearAdaptiveData();
        this.documentConfidence = new Mean();
    }

    public void destroy() {
        this.mNameFinder = null;
    }
}

