/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.doccat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.tools.doccat.DocumentCategorizerEventStream;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.util.DataStreamBuilder;
import opennlp.uima.util.CasConsumerUtil;
import opennlp.uima.util.OpennlpUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

public class DocumentCategorizerTrainer
extends CasConsumer_ImplBase {
    private UimaContext mContext;
    private Logger mLogger;
    private String mModelName;
    private DataStreamBuilder documentSamples;
    private Type mTokenType;
    private Type mCategoryType;
    private Feature mCategoryFeature;

    public void initialize() throws ResourceInitializationException {
        this.mContext = this.getUimaContext();
        this.mLogger = this.mContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Name Trainer.");
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        String tokenTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mTokenType = CasConsumerUtil.getType(typeSystem, tokenTypeName);
        String categoryTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.doccat.CategoryType");
        this.mCategoryType = CasConsumerUtil.getType(typeSystem, categoryTypeName);
        String categoryFeatureName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.doccat.CategoryFeature");
        this.mCategoryFeature = this.mCategoryType.getFeatureByBaseName(categoryFeatureName);
    }

    public void processCas(CAS cas) throws ResourceProcessException {
        AnnotationIndex<AnnotationFS> categoryIndex = cas.getAnnotationIndex(this.mCategoryType);
        if (categoryIndex.size() > 0) {
            AnnotationFS categoryAnnotation = (AnnotationFS)categoryIndex.iterator().next();
            DocumentSample sample = new DocumentSample(categoryAnnotation.getStringValue(this.mCategoryFeature), cas.getDocumentText());
            this.documentSamples.add(sample);
        }
    }

    public void collectionProcessComplete(ProcessTrace trace) throws ResourceProcessException, IOException {
        GIS.PRINT_MESSAGES = false;
        DocumentCategorizerEventStream categroyEventStream = new DocumentCategorizerEventStream(this.documentSamples);
        GISModel categoryModel = DocumentCategorizerME.train(categroyEventStream);
        File modelFile = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + this.mModelName);
        OpennlpUtil.serialize(categoryModel, new FileOutputStream(modelFile));
    }

    public boolean isStateless() {
        return false;
    }

    public void destroy() {
        this.documentSamples = null;
    }
}

