/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.util.Arrays;
import java.util.List;
import opennlp.maxent.MaxentModel;
import opennlp.tools.util.BeamSearchContextGenerator;
import opennlp.tools.util.Cache;
import opennlp.tools.util.ListHeap;
import opennlp.tools.util.Sequence;

public class BeamSearch {
    protected MaxentModel model;
    protected BeamSearchContextGenerator cg;
    protected int size;
    private static final Object[] EMPTY_ADDITIONAL_CONTEXT = new Object[0];
    private double[] probs;
    private Cache contextsCache;
    private static final int zeroLog = -100000;

    public BeamSearch(int size2, BeamSearchContextGenerator cg, MaxentModel model) {
        this(size2, cg, model, 0);
    }

    public BeamSearch(int size2, BeamSearchContextGenerator cg, MaxentModel model, int cacheSize) {
        this.size = size2;
        this.cg = cg;
        this.model = model;
        this.probs = new double[model.getNumOutcomes()];
        if (cacheSize > 0) {
            this.contextsCache = new Cache(cacheSize);
        }
    }

    public Sequence[] bestSequences(int numSequences, Object[] sequence2, Object[] additionalContext) {
        return this.bestSequences(numSequences, sequence2, additionalContext, -100000.0);
    }

    public Sequence[] bestSequences(int numSequences, Object[] sequence2, Object[] additionalContext, double minSequenceScore) {
        int n = sequence2.length;
        ListHeap prev = new ListHeap(this.size);
        ListHeap next2 = new ListHeap(this.size);
        prev.add(new Sequence());
        if (additionalContext == null) {
            additionalContext = EMPTY_ADDITIONAL_CONTEXT;
        }
        for (int i = 0; i < n; ++i) {
            int sz = Math.min(this.size, prev.size());
            for (int sc = 0; prev.size() > 0 && sc < sz; ++sc) {
                Sequence ns;
                String out;
                int p;
                double[] scores;
                Sequence top = (Sequence)prev.extract();
                List tmpOutcomes = top.getOutcomes();
                String[] outcomes = tmpOutcomes.toArray(new String[tmpOutcomes.size()]);
                String[] contexts = this.cg.getContext(i, sequence2, outcomes, additionalContext);
                if (this.contextsCache != null) {
                    scores = (double[])this.contextsCache.get(contexts);
                    if (scores == null) {
                        scores = this.model.eval(contexts, this.probs);
                        this.contextsCache.put(contexts, scores);
                    }
                } else {
                    scores = this.model.eval(contexts, this.probs);
                }
                double[] temp_scores = new double[scores.length];
                for (int c = 0; c < scores.length; ++c) {
                    temp_scores[c] = scores[c];
                }
                Arrays.sort(temp_scores);
                double min2 = temp_scores[Math.max(0, scores.length - this.size)];
                for (p = 0; p < scores.length; ++p) {
                    if (scores[p] < min2 || !this.validSequence(i, sequence2, outcomes, out = this.model.getOutcome(p)) || !((ns = new Sequence(top, out, scores[p])).getScore() > minSequenceScore)) continue;
                    next2.add(ns);
                }
                if (next2.size() != 0) continue;
                for (p = 0; p < scores.length; ++p) {
                    out = this.model.getOutcome(p);
                    if (!this.validSequence(i, sequence2, outcomes, out) || !((ns = new Sequence(top, out, scores[p])).getScore() > minSequenceScore)) continue;
                    next2.add(ns);
                }
            }
            prev.clear();
            ListHeap tmp = prev;
            prev = next2;
            next2 = tmp;
        }
        int numSeq = Math.min(numSequences, prev.size());
        Sequence[] topSequences = new Sequence[numSeq];
        for (int seqIndex = 0; seqIndex < numSeq; ++seqIndex) {
            topSequences[seqIndex] = (Sequence)prev.extract();
        }
        return topSequences;
    }

    public Sequence bestSequence(List sequence2, Object[] additionalContext) {
        return this.bestSequences(1, sequence2.toArray(), additionalContext)[0];
    }

    public Sequence bestSequence(Object[] sequence2, Object[] additionalContext) {
        return this.bestSequences(1, sequence2, additionalContext, -100000.0)[0];
    }

    protected boolean validSequence(int i, Object[] inputSequence, String[] outcomesSequence, String outcome) {
        return true;
    }
}

