/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import opennlp.maxent.Event;
import opennlp.maxent.EventCollector;
import opennlp.tools.tokenize.DefaultTokenContextGenerator;
import opennlp.tools.tokenize.TokenContextGenerator;
import opennlp.tools.tokenize.TokenizerME;

public class TokEventCollector
implements EventCollector {
    private static final TokenContextGenerator cg = new DefaultTokenContextGenerator();
    private BufferedReader br;

    public TokEventCollector(Reader data2) {
        this.br = new BufferedReader(data2);
    }

    public Event[] getEvents() {
        ArrayList<Event> elist = new ArrayList<Event>();
        try {
            String s = this.br.readLine();
            while (s != null) {
                String[] spaceToks = s.split(" ");
                for (int tok = 0; tok < spaceToks.length; ++tok) {
                    StringBuffer sb = new StringBuffer(spaceToks[tok]);
                    if (!TokenizerME.alphaNumeric.matcher(spaceToks[tok]).matches()) continue;
                    int lastIndex = sb.length() - 1;
                    for (int id = 0; id < sb.length(); ++id) {
                        String[] context = cg.getContext(sb.toString(), id);
                        if (id == lastIndex) {
                            elist.add(new Event("T", context));
                            continue;
                        }
                        elist.add(new Event("F", context));
                    }
                }
                s = this.br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Event[] events2 = new Event[elist.size()];
        elist.toArray(events2);
        return events2;
    }

    public Event[] getEvents(boolean evalMode) {
        return this.getEvents();
    }
}

