/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import opennlp.tools.ngram.Token;

public class TokenList {
    private Token[] mTokens;

    public TokenList(Token[] tokens) {
        if (tokens == null || tokens.length == 0) {
            throw new IllegalArgumentException();
        }
        this.mTokens = new Token[tokens.length];
        System.arraycopy(tokens, 0, this.mTokens, 0, tokens.length);
    }

    public TokenList(String[] tokens) {
        if (tokens == null || tokens.length == 0) {
            throw new IllegalArgumentException();
        }
        this.mTokens = new Token[tokens.length];
        for (int ti = 0; ti < tokens.length; ++ti) {
            this.mTokens[ti] = Token.create(tokens[ti]);
        }
    }

    public Token getToken(int index) {
        return this.mTokens[index];
    }

    public int size() {
        return this.mTokens.length;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int mIndex;

            public boolean hasNext() {
                return this.mIndex < TokenList.this.size();
            }

            public Object next() {
                if (this.hasNext()) {
                    return TokenList.this.getToken(this.mIndex++);
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean compareToIgnoreCase(TokenList tokens) {
        if (this.size() == tokens.size()) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.getToken(i).getToken().compareToIgnoreCase(tokens.getToken(i).getToken()) == 0) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        boolean result2;
        if (this == obj) {
            result2 = true;
        } else if (obj != null && obj instanceof TokenList) {
            TokenList tokenList = (TokenList)obj;
            result2 = Arrays.equals(this.mTokens, tokenList.mTokens);
        } else {
            result2 = false;
        }
        return result2;
    }

    public int hashCode() {
        int numBitsRegular = 32 / this.size();
        int numExtra = 32 % this.size();
        int maskExtra = -1 >>> 32 - numBitsRegular + 1;
        int maskRegular = -1 >>> 32 - numBitsRegular;
        int code = 0;
        int leftMostBit = 0;
        for (int wi = 0; wi < this.size(); ++wi) {
            int numBits;
            int mask;
            if (wi < numExtra) {
                mask = maskExtra;
                numBits = numBitsRegular + 1;
            } else {
                mask = maskRegular;
                numBits = numBitsRegular;
            }
            int word = this.getToken(wi).hashCode() & mask;
            code |= (word <<= 32 - (leftMostBit += numBits) - numBits);
        }
        return code;
    }

    public String toString() {
        StringBuffer string2 = new StringBuffer();
        string2.append('[');
        for (int i = 0; i < this.size(); ++i) {
            Token token2 = this.getToken(i);
            string2.append(token2.getToken());
            if (i >= this.size() - 1) continue;
            string2.append(',');
        }
        string2.append(']');
        return string2.toString();
    }
}

