/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.ArrayList;
import opennlp.maxent.DataStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleStream;
import opennlp.tools.ngram.Token;
import opennlp.tools.util.Span;

public class NameSampleDataStream
implements NameSampleStream {
    public static final String START_TAG = "<START>";
    public static final String END_TAG = "<END>";
    private final DataStream in;

    public NameSampleDataStream(DataStream in) {
        this.in = in;
    }

    public boolean hasNext() {
        return this.in.hasNext();
    }

    public NameSample next() {
        String token2 = (String)this.in.nextToken();
        return this.createNameSample(token2);
    }

    private NameSample createNameSample(String taggedTokens) {
        String[] parts = taggedTokens.split(" ");
        ArrayList<Token> tokenList = new ArrayList<Token>(parts.length);
        ArrayList<Span> nameList = new ArrayList<Span>();
        int startIndex = -1;
        int wordIndex = 0;
        for (int pi = 0; pi < parts.length; ++pi) {
            if (parts[pi].equals(START_TAG)) {
                startIndex = wordIndex;
                continue;
            }
            if (parts[pi].equals(END_TAG)) {
                if (startIndex == -1) {
                    throw new RuntimeException("Invalid name near " + pi + " in: " + taggedTokens);
                }
                nameList.add(new Span(startIndex, wordIndex));
                startIndex = -1;
                continue;
            }
            if (parts[pi].length() <= 0) continue;
            tokenList.add(Token.create(parts[pi]));
            ++wordIndex;
        }
        if (startIndex != -1) {
            throw new RuntimeException("Invalid name near " + startIndex + " in: " + taggedTokens);
        }
        Token[] sentence = tokenList.toArray(new Token[tokenList.size()]);
        Span[] names = nameList.toArray(new Span[nameList.size()]);
        return new NameSample(sentence, names, sentence.length == 0);
    }
}

