/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.regex.Pattern;

public class FeatureGeneratorUtil {
    private static Pattern lowercase = Pattern.compile("^[a-z]+$");
    private static Pattern twoDigits = Pattern.compile("^[0-9][0-9]$");
    private static Pattern fourDigits = Pattern.compile("^[0-9][0-9][0-9][0-9]$");
    private static Pattern containsNumber = Pattern.compile("[0-9]");
    private static Pattern containsLetter = Pattern.compile("[a-zA-Z]");
    private static Pattern containsHyphens = Pattern.compile("-");
    private static Pattern containsBackslash = Pattern.compile("/");
    private static Pattern containsComma = Pattern.compile(",");
    private static Pattern containsPeriod = Pattern.compile("\\.");
    private static Pattern allCaps = Pattern.compile("^[A-Z]+$");
    private static Pattern capPeriod = Pattern.compile("^[A-Z]\\.$");
    private static Pattern initialCap = Pattern.compile("^[A-Z]");

    protected static String tokenFeature(String token2) {
        String feat = lowercase.matcher(token2).find() ? "lc" : (twoDigits.matcher(token2).find() ? "2d" : (fourDigits.matcher(token2).find() ? "4d" : (containsNumber.matcher(token2).find() ? (containsLetter.matcher(token2).find() ? "an" : (containsHyphens.matcher(token2).find() ? "dd" : (containsBackslash.matcher(token2).find() ? "ds" : (containsComma.matcher(token2).find() ? "dc" : (containsPeriod.matcher(token2).find() ? "dp" : "num"))))) : (allCaps.matcher(token2).find() && token2.length() == 1 ? "sc" : (allCaps.matcher(token2).find() ? "ac" : (capPeriod.matcher(token2).find() ? "cp" : (initialCap.matcher(token2).find() ? "ic" : "other")))))));
        return feat;
    }
}

