/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.LinkedList;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.dictionary.Index;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.ngram.Token;
import opennlp.tools.ngram.TokenList;
import opennlp.tools.util.Span;

public class DictionaryNameFinder
implements TokenNameFinder {
    private Dictionary mDictionary;
    private Index mMetaDictionary;

    public DictionaryNameFinder(Dictionary dictionary) {
        this.mDictionary = dictionary;
        this.mMetaDictionary = new Index(dictionary.iterator());
    }

    public Span[] find(String[] tokenStrings) {
        LinkedList<Span> foundNames = new LinkedList<Span>();
        for (int startToken = 0; startToken < tokenStrings.length; ++startToken) {
            Span foundName = null;
            Token[] tokens = new Token[]{};
            for (int endToken = startToken; endToken < tokenStrings.length; ++endToken) {
                Token token2 = Token.create(tokenStrings[endToken]);
                Token[] newTokens = new Token[tokens.length + 1];
                System.arraycopy(tokens, 0, newTokens, 0, tokens.length);
                newTokens[newTokens.length - 1] = token2;
                tokens = newTokens;
                if (!this.mMetaDictionary.contains(token2)) break;
                TokenList tokenList = new TokenList(tokens);
                if (!this.mDictionary.contains(tokenList)) continue;
                foundName = new Span(startToken, endToken + 1);
            }
            if (foundName == null) continue;
            foundNames.add(foundName);
        }
        return foundNames.toArray(new Span[foundNames.size()]);
    }
}

