/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.thai;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.tools.lang.thai.EndOfSentenceScanner;
import opennlp.tools.lang.thai.SentenceContextGenerator;
import opennlp.tools.sentdetect.SentenceDetectorME;

public class SentenceDetector
extends SentenceDetectorME {
    public SentenceDetector(String name) throws IOException {
        super(new SuffixSensitiveGISModelReader(new File(name)).getModel(), new SentenceContextGenerator(), new EndOfSentenceScanner());
        this.useTokenEnd = false;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage java opennlp.tools.lang.thai.SentenceDetector model < text");
            System.exit(1);
        }
        SentenceDetector sdetector = new SentenceDetector(args[0]);
        StringBuffer para = new StringBuffer();
        BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        String line = inReader.readLine();
        while (line != null) {
            if (line.equals("")) {
                if (para.length() != 0) {
                    String[] sents = sdetector.sentDetect(para.toString());
                    int sn = sents.length;
                    for (int si = 0; si < sn; ++si) {
                        out.println(sents[si]);
                    }
                }
                out.println();
                para.setLength(0);
            } else {
                para.append(line).append(" ");
            }
            line = inReader.readLine();
        }
        if (para.length() != 0) {
            String[] sents = sdetector.sentDetect(para.toString());
            int sn = sents.length;
            for (int si = 0; si < sn; ++si) {
                out.println(sents[si]);
            }
        }
    }
}

