/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.english;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.tools.tokenize.DefaultTokenContextGenerator;
import opennlp.tools.tokenize.TokSpanEventStream;
import opennlp.tools.tokenize.TokenContextGenerator;
import opennlp.tools.util.Span;

public class TokenStream
implements EventStream {
    private BufferedReader in;
    private String line;
    private Pattern alphaNumeric = Pattern.compile("[A-Za-z0-9]");
    private boolean evenq = true;
    private List events;
    private TokenContextGenerator cg;
    private boolean skipAlphaNumerics;

    public TokenStream(InputStream is) throws IOException {
        this(is, new DefaultTokenContextGenerator(), false);
    }

    public TokenStream(InputStream is, TokenContextGenerator cg, boolean skipAlphaNumerics) throws IOException {
        this.in = new BufferedReader(new InputStreamReader(is));
        this.line = this.in.readLine();
        this.events = new LinkedList();
        this.cg = cg;
        this.skipAlphaNumerics = skipAlphaNumerics;
    }

    public boolean hasNext() {
        return this.events.size() != 0 || this.line != null;
    }

    public Event nextEvent() {
        while (this.events.size() == 0) {
            String[] tokens = this.line.split("\\s+");
            if (tokens.length == 0) {
                this.evenq = true;
            }
            StringBuffer sb = new StringBuffer(this.line.length());
            ArrayList<Span> spans = new ArrayList<Span>();
            int length = 0;
            for (int ti = 0; ti < tokens.length; ++ti) {
                String lastToken;
                String token2 = tokens[ti];
                String string2 = lastToken = ti - 1 >= 0 ? tokens[ti - 1] : "";
                if (token2.equals("-LRB-")) {
                    token2 = "(";
                } else if (token2.equals("-LCB-")) {
                    token2 = "{";
                } else if (token2.equals("-RRB-")) {
                    token2 = ")";
                } else if (token2.equals("-RCB-")) {
                    token2 = "}";
                }
                if (sb.length() != 0) {
                    if (!this.alphaNumeric.matcher(token2).find() || token2.startsWith("'") || token2.equalsIgnoreCase("n't")) {
                        if ((token2.equals("``") || token2.equals("--") || token2.equals("$") || token2.equals("(") || token2.equals("&") || token2.equals("#") || token2.equals("\"") && this.evenq && ti != tokens.length - 1) && (!lastToken.equals("(") || !lastToken.equals("{"))) {
                            ++length;
                        }
                    } else if (!(lastToken.equals("``") || lastToken.equals("\"") && !this.evenq || lastToken.equals("(") || lastToken.equals("{") || lastToken.equals("$") || lastToken.equals("#"))) {
                        ++length;
                    }
                }
                if (token2.equals("\"")) {
                    if (ti == tokens.length - 1) {
                        this.evenq = true;
                    } else {
                        boolean bl = this.evenq = !this.evenq;
                    }
                }
                if (sb.length() < length) {
                    sb.append(" ");
                }
                sb.append(token2);
                spans.add(new Span(length, length + token2.length()));
                length += token2.length();
            }
            Event[] levents = TokSpanEventStream.createEvents(spans.toArray(new Span[spans.size()]), sb.toString(), this.skipAlphaNumerics, this.cg);
            this.events.addAll(Arrays.asList(levents));
            try {
                this.line = this.in.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.line = null;
            }
        }
        return (Event)this.events.remove(0);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static void usage() {
        System.err.println("TokenStream < in");
        System.err.println("Where \"in\" is a space delimited list of tokens.");
    }

    public static void main(String[] args) throws IOException {
        int ai = 0;
        while (ai < args.length) {
            System.err.println("Unknown option " + args[ai]);
            TokenStream.usage();
            System.exit(1);
        }
        TokenStream tss = new TokenStream(System.in);
        while (tss.hasNext()) {
            Event evt = tss.nextEvent();
            System.out.println(evt);
        }
    }
}

