/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.io.IOException;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.TwoPassDataIndexer;
import opennlp.tools.doccat.BagOfWordsFeatureGenerator;
import opennlp.tools.doccat.DocumentCategorizer;
import opennlp.tools.doccat.DocumentCategorizerContextGenerator;
import opennlp.tools.doccat.DocumentCategorizerEventStream;
import opennlp.tools.doccat.FeatureGenerator;
import opennlp.tools.tokenize.SimpleTokenizer;

public class DocumentCategorizerME
implements DocumentCategorizer {
    MaxentModel mModel;
    private DocumentCategorizerContextGenerator mContextGenerator;

    public DocumentCategorizerME(MaxentModel model) {
        this(model, new FeatureGenerator[]{new BagOfWordsFeatureGenerator()});
    }

    public DocumentCategorizerME(MaxentModel model, FeatureGenerator[] featureGenerators) {
        this.mModel = model;
        this.mContextGenerator = new DocumentCategorizerContextGenerator(featureGenerators);
    }

    public double[] categorize(String[] text2) {
        return this.mModel.eval(this.mContextGenerator.getContext(text2));
    }

    public double[] categorize(String documentText) {
        SimpleTokenizer tokenizer = new SimpleTokenizer();
        return this.categorize(tokenizer.tokenize(documentText));
    }

    public String getBestCategory(double[] outcome) {
        return this.mModel.getBestOutcome(outcome);
    }

    public int getIndex(String category) {
        return this.mModel.getIndex(category);
    }

    public String getCategory(int index) {
        return this.mModel.getOutcome(index);
    }

    public int getNumberOfCategories() {
        return this.mModel.getNumOutcomes();
    }

    public String getAllResults(double[] results) {
        return this.mModel.getAllOutcomes(results);
    }

    public static GISModel train(DocumentCategorizerEventStream eventStream) throws IOException {
        return GIS.trainModel(100, new TwoPassDataIndexer(eventStream, 5));
    }
}

