/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import opennlp.maxent.Event;
import opennlp.maxent.GIS;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.BinaryGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.DiscourseModel;
import opennlp.tools.coref.Linker;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.mention.Parse;
import opennlp.tools.coref.resolver.AbstractResolver;
import opennlp.tools.coref.resolver.DefaultNonReferentialResolver;
import opennlp.tools.coref.resolver.FixedNonReferentialResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;
import opennlp.tools.coref.sim.GenderEnum;
import opennlp.tools.coref.sim.NumberEnum;
import opennlp.tools.coref.sim.TestSimilarityModel;
import opennlp.tools.util.CollectionEventStream;

public abstract class MaxentResolver
extends AbstractResolver {
    public static final String SAME = "same";
    public static final String DIFF = "diff";
    public static final String DEFAULT = "default";
    private static final Pattern ENDS_WITH_PERIOD = Pattern.compile("\\.$");
    private static final double MIN_SIM_PROB = 0.6;
    private static final String SIM_COMPATIBLE = "sim.compatible";
    private static final String SIM_INCOMPATIBLE = "sim.incompatible";
    private static final String SIM_UNKNOWN = "sim.unknown";
    private static final String NUM_COMPATIBLE = "num.compatible";
    private static final String NUM_INCOMPATIBLE = "num.incompatible";
    private static final String NUM_UNKNOWN = "num.unknown";
    private static final String GEN_COMPATIBLE = "gen.compatible";
    private static final String GEN_INCOMPATIBLE = "gen.incompatible";
    private static final String GEN_UNKNOWN = "gen.unknown";
    private static boolean debugOn = false;
    private static boolean loadAsResource = false;
    private String modelName;
    private MaxentModel model;
    private double[] candProbs;
    private int sameIndex;
    private ResolverMode mode;
    private List events;
    protected boolean preferFirstReferent;
    protected boolean pairedSampleSelection;
    protected boolean useSameModelForNonRef;
    private static TestSimilarityModel simModel = null;
    protected NonReferentialResolver nonReferentialResolver;
    private static final String modelExtension = ".bin.gz";

    protected MaxentResolver(int numberOfEntitiesBack, boolean preferFirstReferent) {
        super(numberOfEntitiesBack);
        this.preferFirstReferent = preferFirstReferent;
    }

    public MaxentResolver(String modelDirectory, String name, ResolverMode mode, int numberOfEntitiesBack, boolean preferFirstReferent, NonReferentialResolver nonReferentialResolver) throws IOException {
        super(numberOfEntitiesBack);
        this.preferFirstReferent = preferFirstReferent;
        this.nonReferentialResolver = nonReferentialResolver;
        this.mode = mode;
        this.modelName = modelDirectory + "/" + name;
        if (ResolverMode.TEST == this.mode) {
            this.model = loadAsResource ? new BinaryGISModelReader(new DataInputStream(this.getClass().getResourceAsStream(this.modelName + modelExtension))).getModel() : new SuffixSensitiveGISModelReader(new File(this.modelName + modelExtension)).getModel();
            this.sameIndex = this.model.getIndex(SAME);
        } else if (ResolverMode.TRAIN == this.mode) {
            this.events = new ArrayList();
        } else {
            System.err.println("Unknown mode: " + this.mode);
        }
        this.candProbs = new double[this.getNumEntities() + 1];
    }

    public MaxentResolver(String modelDirectory, String modelName, ResolverMode mode, int numberEntitiesBack) throws IOException {
        this(modelDirectory, modelName, mode, numberEntitiesBack, false);
    }

    public MaxentResolver(String modelDirectory, String modelName, ResolverMode mode, int numberEntitiesBack, NonReferentialResolver nonReferentialResolver) throws IOException {
        this(modelDirectory, modelName, mode, numberEntitiesBack, false, nonReferentialResolver);
    }

    public MaxentResolver(String modelDirectory, String modelName, ResolverMode mode, int numberEntitiesBack, boolean preferFirstReferent) throws IOException {
        this(modelDirectory, modelName, mode, numberEntitiesBack, preferFirstReferent, new DefaultNonReferentialResolver(modelDirectory, modelName, mode));
    }

    public MaxentResolver(String modelDirectory, String modelName, ResolverMode mode, int numberEntitiesBack, boolean preferFirstReferent, double nonReferentialProbability) throws IOException {
        this(modelDirectory, modelName, mode, numberEntitiesBack, preferFirstReferent, new FixedNonReferentialResolver(nonReferentialProbability));
    }

    public static void loadAsResource(boolean lar) {
        loadAsResource = lar;
    }

    public static boolean loadAsResource() {
        return loadAsResource;
    }

    public DiscourseEntity resolve(MentionContext ec, DiscourseModel dm) {
        DiscourseEntity de;
        int ei = 0;
        double nonReferentialProbability = this.nonReferentialResolver.getNonReferentialProbability(ec);
        if (debugOn) {
            System.err.println(this + ".resolve: " + ec.toText() + " -> " + "null " + nonReferentialProbability);
        }
        while (ei < this.getNumEntities(dm) && !this.outOfRange(ec, de = dm.getEntity(ei))) {
            if (this.excluded(ec, de)) {
                this.candProbs[ei] = 0.0;
                if (debugOn) {
                    System.err.println("excluded " + this + ".resolve: " + ec.toText() + " -> " + de + " " + this.candProbs[ei]);
                }
            } else {
                List lfeatures = this.getFeatures(ec, de);
                String[] features = lfeatures.toArray(new String[lfeatures.size()]);
                try {
                    this.candProbs[ei] = this.model.eval(features)[this.sameIndex];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.candProbs[ei] = 0.0;
                }
                if (debugOn) {
                    System.err.println(this + ".resolve: " + ec.toText() + " -> " + de + " (" + ec.getGender() + "," + de.getGender() + ") " + this.candProbs[ei] + " " + lfeatures);
                }
            }
            if (this.preferFirstReferent && this.candProbs[ei] > nonReferentialProbability) {
                ++ei;
                break;
            }
            ++ei;
        }
        this.candProbs[ei] = nonReferentialProbability;
        int maxCandIndex = 0;
        for (int k = 1; k <= ei; ++k) {
            if (!(this.candProbs[k] > this.candProbs[maxCandIndex])) continue;
            maxCandIndex = k;
        }
        if (maxCandIndex == ei) {
            return null;
        }
        de = dm.getEntity(maxCandIndex);
        return de;
    }

    protected boolean defaultReferent(DiscourseEntity de) {
        MentionContext ec = de.getLastExtent();
        return ec.getNounPhraseSentenceIndex() == 0;
    }

    public DiscourseEntity retain(MentionContext mention, DiscourseModel dm) {
        if (ResolverMode.TRAIN == this.mode) {
            DiscourseEntity de = null;
            boolean referentFound = false;
            boolean hasReferentialCandidate = false;
            boolean nonReferentFound = false;
            for (int ei = 0; ei < this.getNumEntities(dm); ++ei) {
                DiscourseEntity cde = dm.getEntity(ei);
                MentionContext entityMention = cde.getLastExtent();
                if (this.outOfRange(mention, cde)) {
                    if (mention.getId() == -1 || referentFound) break;
                    break;
                }
                if (this.excluded(mention, cde)) {
                    if (this.showExclusions && mention.getId() != -1 && entityMention.getId() == mention.getId()) {
                        System.err.println(this + ".retain: Referent excluded: (" + mention.getId() + ") " + mention.toText() + " " + mention.getIndexSpan() + " -> (" + entityMention.getId() + ") " + entityMention.toText() + " " + entityMention.getSpan() + " " + this);
                    }
                } else {
                    hasReferentialCandidate = true;
                    boolean useAsDifferentExample = this.defaultReferent(cde);
                    List features = this.getFeatures(mention, cde);
                    if (debugOn) {
                        System.err.println(this + ".retain: " + mention.getId() + " " + mention.toText() + " -> " + entityMention.getId() + " " + cde);
                    }
                    if (mention.getId() != -1 && entityMention.getId() == mention.getId()) {
                        referentFound = true;
                        this.events.add(new Event(SAME, features.toArray(new String[features.size()])));
                        de = cde;
                        this.distances.add(new Integer(ei));
                    } else if (!this.pairedSampleSelection || !nonReferentFound && useAsDifferentExample) {
                        nonReferentFound = true;
                        this.events.add(new Event(DIFF, features.toArray(new String[features.size()])));
                    }
                }
                if (this.pairedSampleSelection && referentFound && nonReferentFound || this.preferFirstReferent && referentFound) break;
            }
            if (hasReferentialCandidate) {
                this.nonReferentialResolver.addEvent(mention);
            }
            return de;
        }
        return super.retain(mention, dm);
    }

    protected String getMentionCountFeature(DiscourseEntity de) {
        if (de.getNumMentions() >= 5) {
            return "mc=5+";
        }
        return "mc=" + de.getNumMentions();
    }

    protected List getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList<String> features = new ArrayList<String>();
        features.add(DEFAULT);
        features.addAll(this.getCompatibilityFeatures(mention, entity));
        return features;
    }

    public void train() throws IOException {
        if (ResolverMode.TRAIN == this.mode) {
            if (debugOn) {
                System.err.println(this + " referential");
                FileWriter writer = new FileWriter(this.modelName + ".events");
                Iterator ei = this.events.iterator();
                while (ei.hasNext()) {
                    Event e = (Event)ei.next();
                    writer.write(e.toString() + "\n");
                }
                writer.close();
            }
            new SuffixSensitiveGISModelWriter(GIS.trainModel(new CollectionEventStream(this.events), 100, 10), new File(this.modelName + modelExtension)).persist();
            this.nonReferentialResolver.train();
        }
    }

    public static void setSimilarityModel(TestSimilarityModel sm) {
        simModel = sm;
    }

    private String getSemanticCompatibilityFeature(MentionContext ec, DiscourseEntity de) {
        if (simModel != null) {
            double best = 0.0;
            Iterator xi = de.getMentions();
            while (xi.hasNext()) {
                MentionContext ec2 = (MentionContext)xi.next();
                double sim = simModel.compatible(ec, ec2);
                if (debugOn) {
                    System.err.println("MaxentResolver.getSemanticCompatibilityFeature: sem-compat " + sim + " " + ec.toText() + " " + ec2.toText());
                }
                if (!(sim > best)) continue;
                best = sim;
            }
            if (best > 0.6) {
                return SIM_COMPATIBLE;
            }
            if (best > 0.4) {
                return SIM_UNKNOWN;
            }
            return SIM_INCOMPATIBLE;
        }
        System.err.println("MaxentResolver: Uninitialized Semantic Model");
        return SIM_UNKNOWN;
    }

    private String getGenderCompatibilityFeature(MentionContext ec, DiscourseEntity de) {
        GenderEnum eg = de.getGender();
        if (eg == GenderEnum.UNKNOWN || ec.getGender() == GenderEnum.UNKNOWN) {
            return GEN_UNKNOWN;
        }
        if (ec.getGender() == eg) {
            return GEN_COMPATIBLE;
        }
        return GEN_INCOMPATIBLE;
    }

    private String getNumberCompatibilityFeature(MentionContext ec, DiscourseEntity de) {
        NumberEnum en = de.getNumber();
        if (en == NumberEnum.UNKNOWN || ec.getNumber() == NumberEnum.UNKNOWN) {
            return NUM_UNKNOWN;
        }
        if (ec.getNumber() == en) {
            return NUM_COMPATIBLE;
        }
        return NUM_INCOMPATIBLE;
    }

    private List getCompatibilityFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList<String> compatFeatures = new ArrayList<String>();
        String semCompatible = this.getSemanticCompatibilityFeature(mention, entity);
        compatFeatures.add(semCompatible);
        String genCompatible = this.getGenderCompatibilityFeature(mention, entity);
        compatFeatures.add(genCompatible);
        String numCompatible = this.getNumberCompatibilityFeature(mention, entity);
        compatFeatures.add(numCompatible);
        if (semCompatible.equals(SIM_COMPATIBLE) && genCompatible.equals(GEN_COMPATIBLE) && numCompatible.equals(NUM_COMPATIBLE)) {
            compatFeatures.add("all.compatible");
        } else if (semCompatible.equals(SIM_INCOMPATIBLE) || genCompatible.equals(GEN_INCOMPATIBLE) || numCompatible.equals(NUM_INCOMPATIBLE)) {
            compatFeatures.add("some.incompatible");
        }
        return compatFeatures;
    }

    public static List getContextFeatures(MentionContext mention) {
        ArrayList<String> features = new ArrayList<String>();
        if (mention.getPreviousToken() != null) {
            features.add("pt=" + mention.getPreviousToken().getSyntacticType());
            features.add("pw=" + ((Object)mention.getPreviousToken()).toString());
        } else {
            features.add("pt=BOS");
            features.add("pw=BOS");
        }
        if (mention.getNextToken() != null) {
            features.add("nt=" + mention.getNextToken().getSyntacticType());
            features.add("nw=" + ((Object)mention.getNextToken()).toString());
        } else {
            features.add("nt=EOS");
            features.add("nw=EOS");
        }
        if (mention.getNextTokenBasal() != null) {
            features.add("bnt=" + mention.getNextTokenBasal().getSyntacticType());
            features.add("bnw=" + ((Object)mention.getNextTokenBasal()).toString());
        } else {
            features.add("bnt=EOS");
            features.add("bnw=EOS");
        }
        return features;
    }

    private Set constructModifierSet(Parse[] tokens, int headIndex) {
        HashSet<String> modSet = new HashSet<String>();
        for (int ti = 0; ti < headIndex; ++ti) {
            Parse tok = tokens[ti];
            modSet.add(((Object)tok).toString().toLowerCase());
        }
        return modSet;
    }

    protected boolean definiteArticle(String tok, String tag) {
        return (tok = tok.toLowerCase()).equals("the") || tok.equals("these") || tok.equals("these") || tag.equals("PRP$");
    }

    private boolean isSubstring(String ecStrip, String xecStrip) {
        int io = xecStrip.indexOf(ecStrip);
        if (io != -1) {
            if (io != 0 && xecStrip.charAt(io - 1) != ' ') {
                return false;
            }
            int end = io + ecStrip.length();
            return end == xecStrip.length() || xecStrip.charAt(end) == ' ';
        }
        return false;
    }

    protected boolean excluded(MentionContext ec, DiscourseEntity de) {
        return super.excluded(ec, de);
    }

    protected List getDistanceFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList<String> features = new ArrayList<String>();
        MentionContext cec = entity.getLastExtent();
        int entityDistance = mention.getNounPhraseDocumentIndex() - cec.getNounPhraseDocumentIndex();
        int sentenceDistance = mention.getSentenceNumber() - cec.getSentenceNumber();
        int hobbsEntityDistance = sentenceDistance == 0 ? cec.getNounPhraseSentenceIndex() : entityDistance + 2 * cec.getNounPhraseSentenceIndex() - cec.getMaxNounPhraseSentenceIndex();
        features.add("hd=" + hobbsEntityDistance);
        features.add("de=" + entityDistance);
        features.add("ds=" + sentenceDistance);
        return features;
    }

    private Map getPronounFeatureMap(String pronoun) {
        HashMap<String, String> pronounMap = new HashMap<String, String>();
        if (Linker.malePronounPattern.matcher(pronoun).matches()) {
            pronounMap.put("gender", "male");
        } else if (Linker.femalePronounPattern.matcher(pronoun).matches()) {
            pronounMap.put("gender", "female");
        } else if (Linker.neuterPronounPattern.matcher(pronoun).matches()) {
            pronounMap.put("gender", "neuter");
        }
        if (Linker.singularPronounPattern.matcher(pronoun).matches()) {
            pronounMap.put("number", "singular");
        } else if (Linker.pluralPronounPattern.matcher(pronoun).matches()) {
            pronounMap.put("number", "plural");
        }
        return pronounMap;
    }

    protected List getPronounMatchFeatures(MentionContext mention, DiscourseEntity entity) {
        boolean foundCompatiblePronoun = false;
        boolean foundIncompatiblePronoun = false;
        if (mention.getHeadTokenTag().startsWith("PRP")) {
            Map pronounMap = this.getPronounFeatureMap(mention.getHeadTokenText());
            Iterator mi = entity.getMentions();
            while (mi.hasNext()) {
                MentionContext candidateMention = (MentionContext)mi.next();
                if (!candidateMention.getHeadTokenTag().startsWith("PRP")) continue;
                if (mention.getHeadTokenText().equalsIgnoreCase(candidateMention.getHeadTokenText())) {
                    foundCompatiblePronoun = true;
                    break;
                }
                Map candidatePronounMap = this.getPronounFeatureMap(candidateMention.getHeadTokenText());
                boolean allKeysMatch = true;
                Iterator ki = pronounMap.keySet().iterator();
                while (ki.hasNext()) {
                    Object key = ki.next();
                    Object cfv = candidatePronounMap.get(key);
                    if (cfv != null) {
                        if (pronounMap.get(key).equals(cfv)) continue;
                        foundIncompatiblePronoun = true;
                        allKeysMatch = false;
                        continue;
                    }
                    allKeysMatch = false;
                }
                if (!allKeysMatch) continue;
                foundCompatiblePronoun = true;
            }
        }
        ArrayList<String> pronounFeatures = new ArrayList<String>();
        if (foundCompatiblePronoun) {
            pronounFeatures.add("compatiblePronoun");
        }
        if (foundIncompatiblePronoun) {
            pronounFeatures.add("incompatiblePronoun");
        }
        return pronounFeatures;
    }

    protected List getStringMatchFeatures(MentionContext mention, DiscourseEntity entity) {
        boolean sameHead = false;
        boolean modsMatch = false;
        boolean titleMatch = false;
        boolean nonTheModsMatch = false;
        ArrayList features = new ArrayList();
        Parse[] mtokens = mention.getTokenParses();
        Set ecModSet = this.constructModifierSet(mtokens, mention.getHeadTokenIndex());
        String mentionHeadString = mention.getHeadTokenText().toLowerCase();
        HashSet<String> featureSet = new HashSet<String>();
        Iterator ei = entity.getMentions();
        while (ei.hasNext()) {
            Set descModSet;
            MentionContext entityMention = (MentionContext)ei.next();
            String exactMatchFeature = this.getExactMatchFeature(entityMention, mention);
            if (exactMatchFeature != null) {
                featureSet.add(exactMatchFeature);
            } else if (entityMention.getParse().isCoordinatedNounPhrase() && !mention.getParse().isCoordinatedNounPhrase()) {
                featureSet.add("cmix");
            } else {
                String mentionStrip = this.stripNp(mention);
                String entityMentionStrip = this.stripNp(entityMention);
                if (mentionStrip != null && entityMentionStrip != null && this.isSubstring(mentionStrip, entityMentionStrip)) {
                    featureSet.add("substring");
                }
            }
            Parse[] xtoks = entityMention.getTokenParses();
            int headIndex = entityMention.getHeadTokenIndex();
            String entityMentionHeadString = entityMention.getHeadTokenText().toLowerCase();
            if (mentionHeadString.equals(entityMentionHeadString)) {
                sameHead = true;
                featureSet.add("hds=" + mentionHeadString);
                if (!modsMatch || !nonTheModsMatch) {
                    modsMatch = true;
                    nonTheModsMatch = true;
                    Set entityMentionModifierSet = this.constructModifierSet(xtoks, headIndex);
                    Iterator mi = ecModSet.iterator();
                    while (mi.hasNext()) {
                        String mw = (String)mi.next();
                        if (entityMentionModifierSet.contains(mw)) continue;
                        modsMatch = false;
                        if (mw.equals("the")) continue;
                        nonTheModsMatch = false;
                        featureSet.add("mmw=" + mw);
                    }
                }
            }
            if (!(descModSet = this.constructModifierSet(xtoks, entityMention.getNonDescriptorStart())).contains(mentionHeadString)) continue;
            titleMatch = true;
        }
        if (!featureSet.isEmpty()) {
            features.addAll(featureSet);
        }
        if (sameHead) {
            features.add("sameHead");
            if (modsMatch) {
                features.add("modsMatch");
            } else if (nonTheModsMatch) {
                features.add("nonTheModsMatch");
            } else {
                features.add("modsMisMatch");
            }
        }
        if (titleMatch) {
            features.add("titleMatch");
        }
        return features;
    }

    private String mentionString(MentionContext ec) {
        StringBuffer sb = new StringBuffer();
        Object[] mtokens = ec.getTokens();
        sb.append(mtokens[0].toString());
        int tl = mtokens.length;
        for (int ti = 1; ti < tl; ++ti) {
            String token2 = mtokens[ti].toString();
            sb.append(" ").append(token2);
        }
        return sb.toString();
    }

    private String excludedTheMentionString(MentionContext ec) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Object[] mtokens = ec.getTokens();
        int tl = mtokens.length;
        for (int ti = 0; ti < tl; ++ti) {
            String token2 = mtokens[ti].toString();
            if (token2.equals("the") || token2.equals("The") || token2.equals("THE")) continue;
            if (!first) {
                sb.append(" ");
            }
            sb.append(token2);
            first = false;
        }
        return sb.toString();
    }

    private String excludedHonorificMentionString(MentionContext ec) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Object[] mtokens = ec.getTokens();
        int tl = mtokens.length;
        for (int ti = 0; ti < tl; ++ti) {
            String token2 = mtokens[ti].toString();
            if (Linker.honorificsPattern.matcher(token2).matches()) continue;
            if (!first) {
                sb.append(" ");
            }
            sb.append(token2);
            first = false;
        }
        return sb.toString();
    }

    private String excludedDeterminerMentionString(MentionContext ec) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Parse[] mtokens = ec.getTokenParses();
        int tl = mtokens.length;
        for (int ti = 0; ti < tl; ++ti) {
            Parse token2 = mtokens[ti];
            String tag = token2.getSyntacticType();
            if (tag.equals("DT")) continue;
            if (!first) {
                sb.append(" ");
            }
            sb.append(((Object)token2).toString());
            first = false;
        }
        return sb.toString();
    }

    private String getExactMatchFeature(MentionContext ec, MentionContext xec) {
        if (this.mentionString(ec).equals(this.mentionString(xec))) {
            return "exactMatch";
        }
        if (this.excludedHonorificMentionString(ec).equals(this.excludedHonorificMentionString(xec))) {
            return "exactMatchNoHonor";
        }
        if (this.excludedTheMentionString(ec).equals(this.excludedTheMentionString(xec))) {
            return "exactMatchNoThe";
        }
        if (this.excludedDeterminerMentionString(ec).equals(this.excludedDeterminerMentionString(xec))) {
            return "exactMatchNoDT";
        }
        return null;
    }

    public static List getWordFeatures(Parse token2) {
        ArrayList<String> wordFeatures = new ArrayList<String>();
        String word = ((Object)token2).toString().toLowerCase();
        String wf = "";
        if (ENDS_WITH_PERIOD.matcher(word).find()) {
            wf = ",endWithPeriod";
        }
        String tokTag = token2.getSyntacticType();
        wordFeatures.add("w=" + word + ",t=" + tokTag + wf);
        wordFeatures.add("t=" + tokTag + wf);
        return wordFeatures;
    }
}

