/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import opennlp.maxent.EventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.TwoPassDataIndexer;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.chunker.ChunkerEventStream;
import opennlp.tools.chunker.DefaultChunkerContextGenerator;
import opennlp.tools.util.BeamSearch;
import opennlp.tools.util.Sequence;

public class ChunkerME
implements Chunker {
    private static final int DEFAULT_BEAM_SIZE = 10;
    protected BeamSearch beam;
    private Sequence bestSequence;
    protected MaxentModel model;

    public ChunkerME(MaxentModel mod) {
        this(mod, new DefaultChunkerContextGenerator(), 10);
    }

    public ChunkerME(MaxentModel mod, ChunkerContextGenerator cg) {
        this(mod, cg, 10);
    }

    public ChunkerME(MaxentModel mod, ChunkerContextGenerator cg, int beamSize) {
        this.beam = new ChunkBeamSearch(beamSize, cg, mod);
        this.model = mod;
    }

    public List chunk(List toks, List tags) {
        this.bestSequence = this.beam.bestSequence(toks, new Object[]{tags.toArray(new String[tags.size()])});
        return this.bestSequence.getOutcomes();
    }

    public String[] chunk(Object[] toks, String[] tags) {
        this.bestSequence = this.beam.bestSequence(Arrays.asList(toks), new Object[]{tags});
        List c = this.bestSequence.getOutcomes();
        return c.toArray(new String[c.size()]);
    }

    protected boolean validOutcome(String outcome, String[] sequence2) {
        return true;
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    public static GISModel train(EventStream es, int iterations, int cut) throws IOException {
        return GIS.trainModel(iterations, new TwoPassDataIndexer(es, cut));
    }

    private static void usage() {
        System.err.println("Usage: ChunkerME [-encoding charset] trainingFile modelFile");
        System.err.println();
        System.err.println("Training file should be one word per line where each line consists of a ");
        System.err.println("space-delimited triple of \"word pos outcome\".  Sentence breaks are indicated by blank lines.");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            ChunkerME.usage();
        }
        int ai = 0;
        String encoding = null;
        while (args[ai].startsWith("-")) {
            if (args[ai].equals("-encoding") && ai + 1 < args.length) {
                encoding = args[++ai];
            } else {
                System.err.println("Unknown option: " + args[ai]);
                ChunkerME.usage();
            }
            ++ai;
        }
        File inFile = null;
        File outFile = null;
        if (ai < args.length) {
            inFile = new File(args[ai++]);
        } else {
            ChunkerME.usage();
        }
        if (ai < args.length) {
            outFile = new File(args[ai++]);
        } else {
            ChunkerME.usage();
        }
        int iterations = 100;
        int cutoff = 5;
        if (args.length > ai) {
            iterations = Integer.parseInt(args[ai++]);
        }
        if (args.length > ai) {
            cutoff = Integer.parseInt(args[ai++]);
        }
        ChunkerEventStream es = encoding != null ? new ChunkerEventStream(new PlainTextByLineDataStream(new InputStreamReader((InputStream)new FileInputStream(inFile), encoding))) : new ChunkerEventStream(new PlainTextByLineDataStream(new FileReader(inFile)));
        GISModel mod = ChunkerME.train(es, iterations, cutoff);
        System.out.println("Saving the model as: " + args[1]);
        new SuffixSensitiveGISModelWriter(mod, outFile).persist();
    }

    class ChunkBeamSearch
    extends BeamSearch {
        ChunkBeamSearch(int size2, ChunkerContextGenerator cg, MaxentModel model) {
            super(size2, cg, model);
        }

        protected boolean validSequence(int i, Object[] sequence2, String[] s, String outcome) {
            return ChunkerME.this.validOutcome(outcome, s);
        }
    }
}

