/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.GISModelWriter;

public class PlainTextGISModelWriter
extends GISModelWriter {
    BufferedWriter output;

    public PlainTextGISModelWriter(GISModel model, File f2) throws IOException, FileNotFoundException {
        super(model);
        this.output = f2.getName().endsWith(".gz") ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(f2)))) : new BufferedWriter(new FileWriter(f2));
    }

    public PlainTextGISModelWriter(GISModel model, BufferedWriter bw) {
        super(model);
        this.output = bw;
    }

    protected void writeUTF(String s) throws IOException {
        this.output.write(s);
        this.output.newLine();
    }

    protected void writeInt(int i) throws IOException {
        this.output.write(Integer.toString(i));
        this.output.newLine();
    }

    protected void writeDouble(double d) throws IOException {
        this.output.write(Double.toString(d));
        this.output.newLine();
    }

    protected void close() throws IOException {
        this.output.flush();
        this.output.close();
    }
}

