/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.FileReader;
import java.io.IOException;
import opennlp.maxent.BasicContextGenerator;
import opennlp.maxent.ContextGenerator;
import opennlp.maxent.DataStream;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.RealValueFileEventStream;

public class RealBasicEventStream
implements EventStream {
    ContextGenerator cg = new BasicContextGenerator();
    DataStream ds;
    Event next;

    public RealBasicEventStream(DataStream ds) {
        this.ds = ds;
        if (this.ds.hasNext()) {
            this.next = this.createEvent((String)this.ds.nextToken());
        }
    }

    public Event nextEvent() {
        while (this.next == null && this.ds.hasNext()) {
            this.next = this.createEvent((String)this.ds.nextToken());
        }
        Event current = this.next;
        this.next = this.ds.hasNext() ? this.createEvent((String)this.ds.nextToken()) : null;
        return current;
    }

    public boolean hasNext() {
        while (this.next == null && this.ds.hasNext()) {
            this.next = this.createEvent((String)this.ds.nextToken());
        }
        return this.next != null;
    }

    private Event createEvent(String obs) {
        int lastSpace = obs.lastIndexOf(32);
        if (lastSpace == -1) {
            return null;
        }
        String[] contexts = obs.substring(0, lastSpace).split("\\s+");
        float[] values2 = RealValueFileEventStream.parseContexts(contexts);
        return new Event(obs.substring(lastSpace + 1), contexts, values2);
    }

    public static void main(String[] args) throws IOException {
        RealBasicEventStream es = new RealBasicEventStream(new PlainTextByLineDataStream(new FileReader(args[0])));
        while (es.hasNext()) {
            System.out.println(es.nextEvent());
        }
    }
}

