/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.trove.TIntArrayList;
import gnu.trove.TLinkedList;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.maxent.ComparableEvent;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.maxent.OnePassDataIndexer;

public class OnePassRealValueDataIndexer
extends OnePassDataIndexer {
    float[][] values;

    public OnePassRealValueDataIndexer(EventStream eventStream, int cutoff) {
        super(eventStream, cutoff);
    }

    public float[][] getValues() {
        return this.values;
    }

    protected int sortAndMerge(List eventsToCompare) {
        int numUniqueEvents = super.sortAndMerge(eventsToCompare);
        this.values = new float[numUniqueEvents][];
        int numEvents = eventsToCompare.size();
        int i = 0;
        int j = 0;
        while (i < numEvents) {
            ComparableEvent evt = (ComparableEvent)eventsToCompare.get(i);
            if (evt != null) {
                this.values[j++] = evt.values;
            }
            ++i;
        }
        return numUniqueEvents;
    }

    protected List index(TLinkedList events2, TObjectIntHashMap predicateIndex) {
        TObjectIntHashMap<String> omap = new TObjectIntHashMap<String>();
        int numEvents = events2.size();
        int outcomeCount = 0;
        ArrayList<ComparableEvent> eventsToCompare = new ArrayList<ComparableEvent>(numEvents);
        TIntArrayList indexedContext = new TIntArrayList();
        int eventIndex = 0;
        while (eventIndex < numEvents) {
            int ocID;
            Event ev = (Event)events2.removeFirst();
            String[] econtext = ev.getContext();
            String oc = ev.getOutcome();
            if (omap.containsKey(oc)) {
                ocID = omap.get(oc);
            } else {
                ocID = outcomeCount++;
                omap.put(oc, ocID);
            }
            int i = 0;
            while (i < econtext.length) {
                String pred = econtext[i];
                if (predicateIndex.containsKey(pred)) {
                    indexedContext.add(predicateIndex.get(pred));
                }
                ++i;
            }
            if (indexedContext.size() > 0) {
                ComparableEvent ce = new ComparableEvent(ocID, indexedContext.toNativeArray(), ev.getValues());
                eventsToCompare.add(ce);
            } else {
                System.err.println("Dropped event " + ev.getOutcome() + ":" + Arrays.asList(ev.getContext()));
            }
            indexedContext.resetQuick();
            ++eventIndex;
        }
        this.outcomeLabels = OnePassRealValueDataIndexer.toIndexedStringArray(omap);
        this.predLabels = OnePassRealValueDataIndexer.toIndexedStringArray(predicateIndex);
        return eventsToCompare;
    }
}

