/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xslt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.XMLException;
import nu.xom.xslt.XOMResult;
import nu.xom.xslt.XOMSource;
import nu.xom.xslt.XSLException;
import org.xml.sax.SAXParseException;

public final class XSLTransform {
    private Templates templates;
    private NodeFactory factory;
    private Map parameters = new HashMap();
    private static ErrorListener errorsAreFatal = new FatalListener();

    private XSLTransform(Source source) throws XSLException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setErrorListener(errorsAreFatal);
            this.templates = transformerFactory.newTemplates(source);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new XSLException("Could not locate a TrAX TransformerFactory", transformerFactoryConfigurationError);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XSLException("Syntax error in stylesheet", transformerConfigurationException);
        }
    }

    public XSLTransform(Document document2) throws XSLException {
        this(document2, new NodeFactory());
    }

    public XSLTransform(Document document2, NodeFactory nodeFactory) throws XSLException {
        this(new XOMSource(document2));
        this.factory = nodeFactory == null ? new NodeFactory() : nodeFactory;
    }

    public Nodes transform(Document document2) throws XSLException {
        return this.transform(new XOMSource(document2));
    }

    public void setParameter(String string2, Object object) {
        this.setParameter(string2, null, object);
    }

    public void setParameter(String string2, String string3, Object object) {
        if (string3 == null || "".equals(string3)) {
            this._setParameter(string2, object);
        } else {
            this._setParameter("{" + string3 + "}" + string2, object);
        }
    }

    private void _setParameter(String string2, Object object) {
        if (object == null) {
            this.parameters.remove(string2);
        } else {
            this.parameters.put(string2, object);
        }
    }

    public Nodes transform(Nodes nodes) throws XSLException {
        if (nodes.size() == 0) {
            return new Nodes();
        }
        XOMSource xOMSource = new XOMSource(nodes);
        return this.transform(xOMSource);
    }

    private Nodes transform(Source source) throws XSLException {
        try {
            XOMResult xOMResult = new XOMResult(this.factory);
            Transformer transformer = this.templates.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setErrorListener(errorsAreFatal);
            Iterator iterator2 = this.parameters.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                Object v = this.parameters.get(string2);
                transformer.setParameter(string2, v);
            }
            transformer.transform(source, xOMResult);
            return xOMResult.getResult();
        }
        catch (Exception exception) {
            TransformerException transformerException;
            Throwable throwable;
            Throwable throwable2 = exception;
            if (throwable2 instanceof TransformerException && (throwable = (transformerException = (TransformerException)throwable2).getException()) != null && (throwable2 = throwable) instanceof SAXParseException && (throwable = ((SAXParseException)throwable2).getException()) != null) {
                throwable2 = throwable;
            }
            throw new XSLException(exception.getMessage(), throwable2);
        }
    }

    public static Document toDocument(Nodes nodes) {
        int n;
        Element element = null;
        int n2 = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            if (!(nodes.get(i) instanceof Element)) continue;
            n2 = i;
            element = (Element)nodes.get(i);
            break;
        }
        if (element == null) {
            throw new XMLException("No root element");
        }
        Document document2 = new Document(element);
        for (n = 0; n < n2; ++n) {
            document2.insertChild(nodes.get(n), n);
        }
        for (n = n2 + 1; n < nodes.size(); ++n) {
            document2.appendChild(nodes.get(n));
        }
        return document2;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": " + this.templates + "]";
    }

    private static class FatalListener
    implements ErrorListener {
        private FatalListener() {
        }

        public void warning(TransformerException transformerException) {
        }

        public void error(TransformerException transformerException) throws TransformerException {
            throw transformerException;
        }

        public void fatalError(TransformerException transformerException) throws TransformerException {
            throw transformerException;
        }
    }
}

