/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xslt;

import java.util.ArrayList;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.NamespaceConflictException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.XMLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

class XSLTHandler
implements ContentHandler,
LexicalHandler {
    private final Nodes result;
    private final ArrayList parents;
    private final NodeFactory factory;
    private StringBuffer buffer;
    private Element current;
    private AttributesImpl namespaceDeclarations = new AttributesImpl();

    XSLTHandler(NodeFactory nodeFactory) {
        this.factory = nodeFactory;
        this.result = new Nodes();
        this.parents = new ArrayList();
        this.buffer = new StringBuffer();
    }

    Nodes getResult() {
        this.flushText();
        return this.result;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) {
        Object object;
        String string5;
        String string6;
        String string7;
        int n;
        this.flushText();
        int n2 = attributes.getLength();
        for (int i = 0; i < n2; ++i) {
            this.namespaceDeclarations.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
        }
        attributes = this.namespaceDeclarations;
        Element element = this.factory.startMakingElement(string4, string2);
        if (this.parents.isEmpty()) {
            this.current = element;
        } else {
            ParentNode parentNode = (ParentNode)this.parents.get(this.parents.size() - 1);
            parentNode.appendChild(element);
        }
        this.parents.add(element);
        n2 = attributes.getLength();
        for (n = 0; n < n2; ++n) {
            string7 = attributes.getQName(n);
            if (string7.equals("xmlns") || string7.startsWith("xmlns:")) continue;
            string6 = attributes.getURI(n);
            string5 = attributes.getValue(n);
            object = this.factory.makeAttribute(string7, string6, string5, Attribute.Type.UNDECLARED);
            int n3 = ((Nodes)object).size();
            block8: for (int i = 0; i < n3; ++i) {
                Node node = ((Nodes)object).get(i);
                if (node instanceof Attribute) {
                    Attribute attribute = (Attribute)node;
                    while (true) {
                        try {
                            element.addAttribute(attribute);
                            continue block8;
                        }
                        catch (NamespaceConflictException namespaceConflictException) {
                            attribute.setNamespace("p" + attribute.getNamespacePrefix(), attribute.getNamespaceURI());
                            continue;
                        }
                        break;
                    }
                }
                element.appendChild(node);
            }
        }
        for (n = 0; n < n2; ++n) {
            string7 = attributes.getQName(n);
            if (string7.startsWith("xmlns:")) {
                string6 = attributes.getValue(n);
                if (string6.equals(object = element.getNamespaceURI(string5 = string7.substring(6)))) continue;
                try {
                    element.addNamespaceDeclaration(string5, string6);
                }
                catch (NamespaceConflictException namespaceConflictException) {}
                continue;
            }
            if (!string7.equals("xmlns")) continue;
            string6 = attributes.getValue(n);
            if (string6 == null) {
                string6 = "";
            }
            if (string6.equals(object = element.getNamespaceURI(string5 = ""))) continue;
            try {
                element.addNamespaceDeclaration(string5, string6);
                continue;
            }
            catch (NamespaceConflictException namespaceConflictException) {
                if (!"http://www.w3.org/XML/1998/namespace".equals(string6) || !"".equals(string5)) continue;
                element.addNamespaceDeclaration("", "");
            }
        }
        this.namespaceDeclarations = new AttributesImpl();
    }

    public void endElement(String string2, String string3, String string4) {
        this.flushText();
        Element element = (Element)this.parents.remove(this.parents.size() - 1);
        if (this.parents.isEmpty()) {
            Nodes nodes = this.factory.finishMakingElement(this.current);
            for (int i = 0; i < nodes.size(); ++i) {
                this.result.append(nodes.get(i));
            }
            this.current = null;
        } else {
            Nodes nodes = this.factory.finishMakingElement(element);
            ParentNode parentNode = element.getParent();
            element.detach();
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                if (node instanceof Attribute) {
                    ((Element)parentNode).addAttribute((Attribute)node);
                    continue;
                }
                parentNode.appendChild(node);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.buffer.append(cArray, n, n2);
    }

    private void flushText() {
        if (this.buffer.length() > 0) {
            Nodes nodes = this.factory.makeText(this.buffer.toString());
            this.addToResultTree(nodes);
            this.buffer = new StringBuffer();
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string2, String string3) throws SAXException {
        if ("saxon:warning".equals(string2)) {
            throw new SAXException("continue");
        }
        if ("javax.xml.transform.disable-output-escaping".equals(string2) || "javax.xml.transform.enable-output-escaping".equals(string2)) {
            return;
        }
        this.flushText();
        int n = string3.indexOf("?>");
        while (n != -1) {
            string3 = string3.substring(0, n) + "? >" + string3.substring(n + 2);
            n = string3.indexOf("?>");
        }
        Nodes nodes = this.factory.makeProcessingInstruction(string2, string3);
        this.addToResultTree(nodes);
    }

    private void addToResultTree(Nodes nodes) {
        if (this.parents.isEmpty()) {
            for (int i = 0; i < nodes.size(); ++i) {
                this.result.append(nodes.get(i));
            }
        } else {
            ParentNode parentNode = (ParentNode)this.parents.get(this.parents.size() - 1);
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                if (node instanceof Attribute) {
                    ((Element)parentNode).addAttribute((Attribute)node);
                    continue;
                }
                parentNode.appendChild(node);
            }
        }
    }

    public void endPrefixMapping(String string2) {
    }

    public void startPrefixMapping(String string2, String string3) {
        if ("".equals(string2)) {
            this.namespaceDeclarations.addAttribute("", "xmlns", "xmlns", "CDATA", string3);
        } else {
            this.namespaceDeclarations.addAttribute("", "xmlns:" + string2, "xmlns:" + string2, "CDATA", string3);
        }
    }

    public void skippedEntity(String string2) {
        this.flushText();
        throw new XMLException("Could not resolve entity " + string2);
    }

    public void startCDATA() {
    }

    public void endCDATA() {
    }

    public void startDTD(String string2, String string3, String string4) {
    }

    public void endDTD() {
    }

    public void startEntity(String string2) {
    }

    public void endEntity(String string2) {
    }

    public void comment(char[] cArray, int n, int n2) {
        this.flushText();
        String string2 = new String(cArray, n, n2);
        int n3 = string2.indexOf("--");
        while (n3 != -1) {
            string2 = string2.substring(0, n3) + "- -" + string2.substring(n3 + 2);
            n3 = string2.indexOf("--");
        }
        if (string2.endsWith("-")) {
            string2 = string2 + ' ';
        }
        this.addToResultTree(this.factory.makeComment(string2));
    }
}

