/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xinclude;

import java.io.IOException;
import java.io.InputStream;

class EncodingHeuristics {
    private EncodingHeuristics() {
    }

    public static String readEncodingFromStream(InputStream inputStream) throws IOException {
        inputStream.mark(1024);
        try {
            int n = inputStream.read();
            int n2 = inputStream.read();
            if (n == 254 && n2 == 255) {
                return "UnicodeBig";
            }
            if (n == 255 && n2 == 254) {
                return "UnicodeLittle";
            }
            int n3 = inputStream.read();
            if (n == 239 && n2 == 187 && n3 == 191) {
                return "UTF-8";
            }
            int n4 = inputStream.read();
            if (n == 0 && n2 == 0 && n3 == 254 && n4 == 255) {
                return "UTF32BE";
            }
            if (n == 0 && n2 == 0 && n3 == 255 && n4 == 254) {
                return "UTF32LE";
            }
            if (n == 0 && n2 == 0 && n3 == 0 && n4 == 60) {
                inputStream.reset();
                return "UTF32BE";
            }
            if (n == 60 && n2 == 0 && n3 == 0 && n4 == 0) {
                inputStream.reset();
                return "UTF32LE";
            }
            if (n == 0 && n2 == 60 && n3 == 0 && n4 == 63) {
                inputStream.reset();
                return "UnicodeBigUnmarked";
            }
            if (n == 60 && n2 == 0 && n3 == 63 && n4 == 0) {
                inputStream.reset();
                return "UnicodeLittleUnmarked";
            }
            if (n == 60 && n2 == 63 && n3 == 120 && n4 == 109) {
                byte[] byArray = new byte[1024];
                byArray[0] = (byte)n;
                byArray[1] = (byte)n2;
                byArray[2] = (byte)n3;
                byArray[3] = (byte)n4;
                int n5 = inputStream.read(byArray, 4, 1020) + 4;
                String string2 = new String(byArray, 0, n5, "8859_1");
                String string3 = EncodingHeuristics.findEncodingDeclaration(string2);
                inputStream.reset();
                return string3;
            }
            if (n == 76 && n2 == 111 && n3 == 167 && n4 == 148) {
                int n6;
                byte[] byArray = new byte[1016];
                for (int i = 0; i < byArray.length && (n6 = inputStream.read()) != -1; ++i) {
                    byArray[i] = (byte)n6;
                }
                inputStream.reset();
                return EncodingHeuristics.findEncodingDeclaration(new String(byArray, "Cp037"));
            }
        }
        catch (IOException iOException) {
            inputStream.reset();
            return "UTF-8";
        }
        catch (RuntimeException runtimeException) {
            inputStream.reset();
            return "UTF-8";
        }
        inputStream.reset();
        return "UTF-8";
    }

    private static String findEncodingDeclaration(String string2) throws IOException {
        char c;
        int n = string2.indexOf("encoding") + 8;
        while ((c = string2.charAt(n++)) == ' ' || c == '\t' || c == '\r' || c == '\n') {
        }
        if (c != '=') {
            throw new IOException("Couldn't determine encoding");
        }
        while ((c = string2.charAt(n++)) == ' ' || c == '\t' || c == '\r' || c == '\n') {
        }
        char c2 = c;
        if (c2 != '\'' && c2 != '\"') {
            return "UTF-8";
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = string2.charAt(n++)) != c2) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

