/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen.function;

import java.util.List;
import nu.xom.jaxen.Context;
import nu.xom.jaxen.Function;
import nu.xom.jaxen.FunctionCallException;
import nu.xom.jaxen.Navigator;
import nu.xom.jaxen.function.StringFunction;

public class StringLengthFunction
implements Function {
    public Object call(Context context, List list2) throws FunctionCallException {
        if (list2.size() == 0) {
            return StringLengthFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (list2.size() == 1) {
            return StringLengthFunction.evaluate(list2.get(0), context.getNavigator());
        }
        throw new FunctionCallException("string-length() requires one argument.");
    }

    public static Double evaluate(Object object, Navigator navigator) throws FunctionCallException {
        String string2 = StringFunction.evaluate(object, navigator);
        char[] cArray = string2.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            ++n;
            if (c < '\ud800' || c > '\udfff') continue;
            try {
                char c2 = cArray[i + 1];
                if (c2 < '\udc00' || c2 > '\udfff') {
                    throw new FunctionCallException("Bad surrogate pair in string " + string2);
                }
                ++i;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new FunctionCallException("Bad surrogate pair in string " + string2);
            }
        }
        return new Double(n);
    }
}

