/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nu.xom.jaxen.Context;
import nu.xom.jaxen.ContextSupport;
import nu.xom.jaxen.JaxenException;
import nu.xom.jaxen.Navigator;
import nu.xom.jaxen.UnresolvableException;
import nu.xom.jaxen.expr.DefaultStep;
import nu.xom.jaxen.expr.IdentitySet;
import nu.xom.jaxen.expr.NameStep;
import nu.xom.jaxen.expr.PredicateSet;
import nu.xom.jaxen.expr.iter.IterableAxis;

public class DefaultNameStep
extends DefaultStep
implements NameStep {
    private static final long serialVersionUID = 428414912247718390L;
    private String prefix;
    private String localName;
    private boolean matchesAnyName;
    private boolean hasPrefix;

    public DefaultNameStep(IterableAxis iterableAxis, String string2, String string3, PredicateSet predicateSet) {
        super(iterableAxis, predicateSet);
        this.prefix = string2;
        this.localName = string3;
        this.matchesAnyName = "*".equals(string3);
        this.hasPrefix = this.prefix != null && this.prefix.length() > 0;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean isMatchesAnyName() {
        return this.matchesAnyName;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getAxisName()).append("::");
        if (this.getPrefix() != null && this.getPrefix().length() > 0) {
            stringBuffer.append(this.getPrefix()).append(':');
        }
        return stringBuffer.append(this.getLocalName()).append(super.getText()).toString();
    }

    public List evaluate(Context context) throws JaxenException {
        boolean bl;
        List list2 = context.getNodeSet();
        int n = list2.size();
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        ContextSupport contextSupport = context.getContextSupport();
        IterableAxis iterableAxis = this.getIterableAxis();
        boolean bl2 = bl = !this.matchesAnyName && iterableAxis.supportsNamedAccess(contextSupport);
        if (n == 1) {
            Object e = list2.get(0);
            if (bl) {
                String string2 = null;
                if (this.hasPrefix && (string2 = contextSupport.translateNamespacePrefixToUri(this.prefix)) == null) {
                    throw new UnresolvableException("XPath expression uses unbound namespace prefix " + this.prefix);
                }
                Iterator iterator2 = iterableAxis.namedAccessIterator(e, contextSupport, this.localName, this.prefix, string2);
                if (iterator2 == null || !iterator2.hasNext()) {
                    return Collections.EMPTY_LIST;
                }
                ArrayList arrayList = new ArrayList();
                while (iterator2.hasNext()) {
                    arrayList.add(iterator2.next());
                }
                return this.getPredicateSet().evaluatePredicates(arrayList, contextSupport);
            }
            Iterator iterator3 = iterableAxis.iterator(e, contextSupport);
            if (iterator3 == null || !iterator3.hasNext()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList arrayList = new ArrayList(n);
            while (iterator3.hasNext()) {
                Object e2 = iterator3.next();
                if (!this.matches(e2, contextSupport)) continue;
                arrayList.add(e2);
            }
            return this.getPredicateSet().evaluatePredicates(arrayList, contextSupport);
        }
        IdentitySet identitySet = new IdentitySet();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        ArrayList arrayList2 = new ArrayList(n);
        if (bl) {
            String string3 = null;
            if (this.hasPrefix && (string3 = contextSupport.translateNamespacePrefixToUri(this.prefix)) == null) {
                throw new UnresolvableException("XPath expression uses unbound namespace prefix " + this.prefix);
            }
            for (int i = 0; i < n; ++i) {
                Object object;
                Object e = list2.get(i);
                Iterator iterator4 = iterableAxis.namedAccessIterator(e, contextSupport, this.localName, this.prefix, string3);
                if (iterator4 == null || !iterator4.hasNext()) continue;
                while (iterator4.hasNext()) {
                    object = iterator4.next();
                    arrayList.add(object);
                }
                object = this.getPredicateSet().evaluatePredicates(arrayList, contextSupport);
                Iterator iterator5 = object.iterator();
                while (iterator5.hasNext()) {
                    Object e3 = iterator5.next();
                    if (identitySet.contains(e3)) continue;
                    identitySet.add(e3);
                    arrayList2.add(e3);
                }
                arrayList.clear();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Object object;
                Object e = list2.get(i);
                Iterator iterator6 = this.axisIterator(e, contextSupport);
                if (iterator6 == null || !iterator6.hasNext()) continue;
                while (iterator6.hasNext()) {
                    object = iterator6.next();
                    if (!this.matches(object, contextSupport)) continue;
                    arrayList.add(object);
                }
                object = this.getPredicateSet().evaluatePredicates(arrayList, contextSupport);
                Iterator iterator7 = object.iterator();
                while (iterator7.hasNext()) {
                    Object e4 = iterator7.next();
                    if (identitySet.contains(e4)) continue;
                    identitySet.add(e4);
                    arrayList2.add(e4);
                }
                arrayList.clear();
            }
        }
        return arrayList2;
    }

    public boolean matches(Object object, ContextSupport contextSupport) throws JaxenException {
        Navigator navigator = contextSupport.getNavigator();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (navigator.isElement(object)) {
            string3 = navigator.getElementName(object);
            string4 = navigator.getElementNamespaceUri(object);
        } else {
            if (navigator.isText(object)) {
                return false;
            }
            if (navigator.isAttribute(object)) {
                if (this.getAxis() != 9) {
                    return false;
                }
                string3 = navigator.getAttributeName(object);
                string4 = navigator.getAttributeNamespaceUri(object);
            } else {
                if (navigator.isDocument(object)) {
                    return false;
                }
                if (navigator.isNamespace(object)) {
                    if (this.getAxis() != 10) {
                        return false;
                    }
                    string3 = navigator.getNamespacePrefix(object);
                } else {
                    return false;
                }
            }
        }
        if (this.hasPrefix) {
            string2 = contextSupport.translateNamespacePrefixToUri(this.prefix);
            if (string2 == null) {
                throw new UnresolvableException("Cannot resolve namespace prefix '" + this.prefix + "'");
            }
        } else if (this.matchesAnyName) {
            return true;
        }
        if (this.hasNamespace(string2) != this.hasNamespace(string4)) {
            return false;
        }
        if (this.matchesAnyName || string3.equals(this.getLocalName())) {
            return this.matchesNamespaceURIs(string2, string4);
        }
        return false;
    }

    private boolean hasNamespace(String string2) {
        return string2 != null && string2.length() > 0;
    }

    protected boolean matchesNamespaceURIs(String string2, String string3) {
        if (string2 == string3) {
            return true;
        }
        if (string2 == null) {
            return string3.length() == 0;
        }
        if (string3 == null) {
            return string2.length() == 0;
        }
        return string2.equals(string3);
    }

    public String toString() {
        String string2 = this.getPrefix();
        String string3 = "".equals(string2) ? this.getLocalName() : this.getPrefix() + ":" + this.getLocalName();
        return "[(DefaultNameStep): " + string3 + "]";
    }
}

