/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.converters;

import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class SAXConverter {
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private LocatorImpl locator;
    private boolean stripBaseAttributes = true;

    public SAXConverter(ContentHandler contentHandler) {
        this.setContentHandler(contentHandler);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException("ContentHandler must be non-null.");
        }
        if ("nu.xom.xslt.XSLTHandler".equals(contentHandler.getClass().getName())) {
            this.stripBaseAttributes = false;
        } else {
            this.contentHandler = contentHandler;
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void convert(Document document2) throws SAXException {
        this.locator = new LocatorImpl();
        this.locator.setSystemId(document2.getBaseURI());
        this.contentHandler.setDocumentLocator(this.locator);
        this.contentHandler.startDocument();
        for (int i = 0; i < document2.getChildCount(); ++i) {
            this.process(document2.getChild(i));
        }
        this.contentHandler.endDocument();
    }

    private void process(Node node) throws SAXException {
        if (node instanceof Element) {
            this.convertElement((Element)node);
        } else if (node instanceof Text) {
            String string2 = node.getValue();
            this.contentHandler.characters(string2.toCharArray(), 0, string2.length());
        } else if (node instanceof ProcessingInstruction) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
            this.contentHandler.processingInstruction(processingInstruction.getTarget(), processingInstruction.getValue());
        } else if (node instanceof Comment && this.lexicalHandler != null) {
            String string3 = node.getValue();
            this.lexicalHandler.comment(string3.toCharArray(), 0, string3.length());
        } else if (node instanceof DocType && this.lexicalHandler != null) {
            DocType docType = (DocType)node;
            this.lexicalHandler.startDTD(docType.getRootElementName(), docType.getPublicID(), docType.getSystemID());
            this.lexicalHandler.endDTD();
        }
    }

    private boolean convertNamespace(Element element, String string2) throws SAXException {
        String string3 = element.getNamespaceURI(string2);
        ParentNode parentNode = element.getParent();
        Element element2 = null;
        if (parentNode instanceof Element) {
            element2 = (Element)parentNode;
        }
        if (element2 != null && string3.equals(element2.getNamespaceURI(string2))) {
            return false;
        }
        if (element2 == null && "".equals(string3)) {
            return false;
        }
        this.contentHandler.startPrefixMapping(string2, string3);
        return true;
    }

    private void convertElement(Element element) throws SAXException {
        int n;
        int n2;
        this.locator.setSystemId(element.getBaseURI());
        int n3 = element.getNamespaceDeclarationCount();
        String[] stringArray = new String[n3];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            String string2 = element.getNamespacePrefix(i);
            n2 = this.convertNamespace(element, string2);
            if (n2 == 0) continue;
            stringArray[n4] = string2;
            ++n4;
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        int n5 = element.getAttributeCount();
        for (n2 = 0; n2 < n5; ++n2) {
            Attribute attribute = element.getAttribute(n2);
            if ("base".equals(attribute.getLocalName()) && "http://www.w3.org/XML/1998/namespace".equals(attribute.getNamespaceURI()) && this.stripBaseAttributes) continue;
            attributesImpl.addAttribute(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getQualifiedName(), SAXConverter.getSAXType(attribute), attribute.getValue());
        }
        this.contentHandler.startElement(element.getNamespaceURI(), element.getLocalName(), element.getQualifiedName(), attributesImpl);
        n2 = element.getChildCount();
        for (n = 0; n < n2; ++n) {
            this.process(element.getChild(n));
        }
        this.contentHandler.endElement(element.getNamespaceURI(), element.getLocalName(), element.getQualifiedName());
        for (n = 0; n < n4; ++n) {
            this.contentHandler.endPrefixMapping(stringArray[n]);
        }
    }

    private static String getSAXType(Attribute attribute) {
        Attribute.Type type = attribute.getType();
        if (type.equals(Attribute.Type.UNDECLARED)) {
            return "CDATA";
        }
        if (type.equals(Attribute.Type.CDATA)) {
            return "CDATA";
        }
        if (type.equals(Attribute.Type.ID)) {
            return "ID";
        }
        if (type.equals(Attribute.Type.IDREF)) {
            return "IDREF";
        }
        if (type.equals(Attribute.Type.IDREFS)) {
            return "IDREFS";
        }
        if (type.equals(Attribute.Type.NMTOKEN)) {
            return "NMTOKEN";
        }
        if (type.equals(Attribute.Type.NMTOKENS)) {
            return "NMTOKENS";
        }
        if (type.equals(Attribute.Type.ENTITY)) {
            return "ENTITY";
        }
        if (type.equals(Attribute.Type.ENTITIES)) {
            return "ENTITIES";
        }
        if (type.equals(Attribute.Type.NOTATION)) {
            return "NOTATION";
        }
        return "NMTOKEN";
    }

    public void convert(Nodes nodes) throws SAXException {
        if (nodes.size() == 1 && nodes.get(0) instanceof Document) {
            this.convert((Document)nodes.get(0));
        } else {
            this.locator = new LocatorImpl();
            this.contentHandler.setDocumentLocator(this.locator);
            this.contentHandler.startDocument();
            for (int i = 0; i < nodes.size(); ++i) {
                this.process(nodes.get(i));
            }
            this.contentHandler.endDocument();
        }
    }
}

