/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.converters;

import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.XMLException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DOMConverter {
    private static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";

    private DOMConverter() {
    }

    public static Document convert(org.w3c.dom.Document document2) {
        return DOMConverter.convert(document2, new NodeFactory());
    }

    public static Document convert(org.w3c.dom.Document document2, NodeFactory nodeFactory) {
        org.w3c.dom.Element element = document2.getDocumentElement();
        Element element2 = nodeFactory.makeRootElement(element.getTagName(), element.getNamespaceURI());
        Document document3 = nodeFactory.startMakingDocument();
        document3.setRootElement(element2);
        Nodes nodes = DOMConverter.convert(element, nodeFactory);
        boolean bl = true;
        int n = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (bl) {
                if (node instanceof Element) {
                    document3.setRootElement((Element)node);
                    bl = false;
                    continue;
                }
                document3.insertChild(node, n++);
                continue;
            }
            document3.appendChild(node);
        }
        org.w3c.dom.Node node = document2.getFirstChild();
        int n2 = 0;
        while (node.getNodeType() != 1) {
            Nodes nodes2 = DOMConverter.convert(node, nodeFactory);
            for (int i = 0; i < nodes2.size(); ++i) {
                document3.insertChild(nodes2.get(i), n2++);
            }
            node = node.getNextSibling();
        }
        for (node = node.getNextSibling(); node != null; node = node.getNextSibling()) {
            Nodes nodes3 = DOMConverter.convert(node, nodeFactory);
            for (int i = 0; i < nodes3.size(); ++i) {
                document3.appendChild(nodes3.get(i));
            }
        }
        return document3;
    }

    public static Nodes convert(DocumentFragment documentFragment) {
        return DOMConverter.convert(documentFragment, new NodeFactory());
    }

    public static Nodes convert(DocumentFragment documentFragment, NodeFactory nodeFactory) {
        Nodes nodes = new Nodes();
        NodeList nodeList = documentFragment.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Nodes nodes2 = DOMConverter.convert(nodeList.item(i), nodeFactory);
            DOMConverter.appendNodes(nodes, nodes2);
        }
        return nodes;
    }

    private static void appendNodes(Nodes nodes, Nodes nodes2) {
        for (int i = 0; i < nodes2.size(); ++i) {
            nodes.append(nodes2.get(i));
        }
    }

    private static Nodes convert(org.w3c.dom.Node node, NodeFactory nodeFactory) {
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                return DOMConverter.convert((org.w3c.dom.Element)node, nodeFactory);
            }
            case 8: {
                return DOMConverter.convert((org.w3c.dom.Comment)node, nodeFactory);
            }
            case 10: {
                return DOMConverter.convert((DocumentType)node, nodeFactory);
            }
            case 3: {
                return DOMConverter.convert((org.w3c.dom.Text)node, nodeFactory);
            }
            case 4: {
                return DOMConverter.convert((org.w3c.dom.Text)node, nodeFactory);
            }
            case 7: {
                return DOMConverter.convert((org.w3c.dom.ProcessingInstruction)node, nodeFactory);
            }
        }
        throw new XMLException("Unexpected DOM node type: " + s);
    }

    public static Comment convert(org.w3c.dom.Comment comment2) {
        return new Comment(comment2.getNodeValue());
    }

    private static Nodes convert(org.w3c.dom.Comment comment2, NodeFactory nodeFactory) {
        return nodeFactory.makeComment(comment2.getNodeValue());
    }

    public static Text convert(org.w3c.dom.Text text2) {
        return new Text(text2.getNodeValue());
    }

    private static Nodes convert(org.w3c.dom.Text text2, NodeFactory nodeFactory) {
        return nodeFactory.makeText(text2.getNodeValue());
    }

    public static Attribute convert(Attr attr2) {
        String string2 = attr2.getName();
        String string3 = attr2.getNamespaceURI();
        if (string3 == null) {
            string3 = "";
        }
        return new Attribute(string2, string3, attr2.getNodeValue());
    }

    public static ProcessingInstruction convert(org.w3c.dom.ProcessingInstruction processingInstruction) {
        return new ProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getNodeValue());
    }

    private static Nodes convert(org.w3c.dom.ProcessingInstruction processingInstruction, NodeFactory nodeFactory) {
        return nodeFactory.makeProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getNodeValue());
    }

    public static DocType convert(DocumentType documentType) {
        DocType docType = new DocType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        docType.setInternalDTDSubset(documentType.getInternalSubset());
        return docType;
    }

    private static Nodes convert(DocumentType documentType, NodeFactory nodeFactory) {
        Nodes nodes = nodeFactory.makeDocType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!(node instanceof DocType)) continue;
            ((DocType)node).setInternalDTDSubset(documentType.getInternalSubset());
            break;
        }
        return nodes;
    }

    public static Element convert(org.w3c.dom.Element element) {
        return (Element)DOMConverter.convert(element, new NodeFactory()).get(0);
    }

    /*
     * Unable to fully structure code
     */
    private static Nodes convert(org.w3c.dom.Element var0, NodeFactory var1_1) {
        var2_2 = var0;
        var3_3 = DOMConverter.makeElement(var0, var1_1);
        if (var3_3 == null) {
            var4_4 = new Nodes();
            var5_6 = var0.getChildNodes();
            for (var6_8 = 0; var6_8 < var5_6.getLength(); ++var6_8) {
                var7_10 = DOMConverter.convert(var5_6.item(var6_8), var1_1);
                for (var8_12 = 0; var8_12 < var7_10.size(); ++var8_12) {
                    var4_4.append(var7_10.get(var8_12));
                }
            }
            return var4_4;
        }
        var4_5 = var3_3;
        var5_7 = false;
        block2: while (true) {
            if (var2_2.hasChildNodes() && !var5_7) {
                var2_2 = var2_2.getFirstChild();
                var5_7 = false;
            } else {
                if (var2_2 == var0) break;
                if (var2_2.getNextSibling() != null) {
                    var2_2 = var2_2.getNextSibling();
                    var5_7 = false;
                } else {
                    var2_2 = var2_2.getParentNode();
                    var5_7 = true;
                    if (var4_5.getParent() == null) continue;
                    var4_5 = var4_5.getParent();
                    continue;
                }
            }
            var6_9 = var2_2.getNodeType();
            if (var6_9 == 1) {
                var7_11 = DOMConverter.makeElement((org.w3c.dom.Element)var2_2, var1_1);
                if (var7_11 == null) continue;
                var4_5.appendChild((Node)var7_11);
                if (!var2_2.hasChildNodes()) continue;
                var4_5 = var7_11;
                continue;
            }
            var7_11 = DOMConverter.convert(var2_2, var1_1);
            var8_13 = 0;
            while (true) {
                if (var8_13 < var7_11.size()) ** break;
                continue block2;
                var4_5.appendChild(var7_11.get(var8_13));
                ++var8_13;
            }
            break;
        }
        return var1_1.finishMakingElement(var3_3);
    }

    private static Element makeElement(org.w3c.dom.Element element, NodeFactory nodeFactory) {
        String string2 = element.getNamespaceURI();
        String string3 = element.getTagName();
        Element element2 = element.getParentNode() == null || element.getParentNode().getNodeType() == 9 ? nodeFactory.makeRootElement(string3, string2) : nodeFactory.startMakingElement(string3, string2);
        if (element2 == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Object object;
            Attr attr2 = (Attr)namedNodeMap.item(i);
            String string4 = attr2.getName();
            String string5 = attr2.getNamespaceURI();
            String string6 = attr2.getValue();
            if (string5 == null) {
                string5 = "";
            }
            if (string5.equals(XMLNS_NAMESPACE)) {
                String string7;
                if (string4.equals("xmlns") || string6.equals(string7 = element2.getNamespaceURI((String)(object = string4.substring(string4.indexOf(58) + 1))))) continue;
                element2.addNamespaceDeclaration((String)object, string6);
                continue;
            }
            object = nodeFactory.makeAttribute(string4, string5, string6, Attribute.Type.UNDECLARED);
            for (int j = 0; j < ((Nodes)object).size(); ++j) {
                Node node = ((Nodes)object).get(j);
                if (node instanceof Attribute) {
                    element2.addAttribute((Attribute)node);
                    continue;
                }
                element2.appendChild(node);
            }
        }
        return element2;
    }

    public static org.w3c.dom.Document convert(Document document2, DOMImplementation dOMImplementation) {
        Element element = document2.getRootElement();
        String string2 = element.getQualifiedName();
        String string3 = element.getNamespaceURI();
        DocType docType = document2.getDocType();
        DocumentType documentType = null;
        if (docType != null) {
            documentType = dOMImplementation.createDocumentType(string2, docType.getPublicID(), docType.getSystemID());
        }
        org.w3c.dom.Document document3 = dOMImplementation.createDocument(string3, string2, documentType);
        org.w3c.dom.Element element2 = document3.getDocumentElement();
        boolean bl = true;
        for (int i = 0; i < document2.getChildCount(); ++i) {
            Node node = document2.getChild(i);
            if (node instanceof DocType) continue;
            if (node instanceof Element) {
                DOMConverter.convert((Element)node, document3);
                bl = false;
                continue;
            }
            org.w3c.dom.Node node2 = DOMConverter.convert(node, document3);
            if (bl) {
                document3.insertBefore(node2, element2);
                continue;
            }
            document3.appendChild(node2);
        }
        return document3;
    }

    private static org.w3c.dom.Node convert(Node node, org.w3c.dom.Document document2) {
        if (node instanceof Text) {
            return DOMConverter.convert((Text)node, document2);
        }
        if (node instanceof Comment) {
            return DOMConverter.convert((Comment)node, document2);
        }
        if (node instanceof ProcessingInstruction) {
            return DOMConverter.convert((ProcessingInstruction)node, document2);
        }
        throw new XMLException("Unexpected node type: " + node.getClass().getName());
    }

    private static org.w3c.dom.Comment convert(Comment comment2, org.w3c.dom.Document document2) {
        return document2.createComment(comment2.getValue());
    }

    private static org.w3c.dom.Text convert(Text text2, org.w3c.dom.Document document2) {
        return document2.createTextNode(text2.getValue());
    }

    private static org.w3c.dom.ProcessingInstruction convert(ProcessingInstruction processingInstruction, org.w3c.dom.Document document2) {
        return document2.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getValue());
    }

    private static org.w3c.dom.Element convert(Element element, org.w3c.dom.Document document2) {
        org.w3c.dom.Element element2 = DOMConverter.makeElement(element, document2);
        org.w3c.dom.Node node = element2;
        Node node2 = element;
        int n = 0;
        int[] nArray = new int[10];
        int n2 = 0;
        nArray[0] = 0;
        boolean bl = false;
        while (true) {
            org.w3c.dom.Node node3;
            Object object;
            if (!bl && node2.getChildCount() > 0) {
                node2 = node2.getChild(0);
                n = 0;
                nArray = DOMConverter.grow(nArray, ++n2);
                nArray[n2] = 0;
            } else {
                bl = false;
                object = node2.getParent();
                node3 = node.getParentNode();
                if (node3.getNodeType() == 1 && node2 instanceof Element) {
                    node = node3;
                }
                if (((ParentNode)object).getChildCount() - 1 == n) {
                    ParentNode parentNode;
                    node2 = object;
                    --n2;
                    if (node2 == element || (parentNode = node2.getParent()) == null) break;
                    n = nArray[n2];
                    bl = true;
                    continue;
                }
                nArray[n2] = ++n;
                node2 = ((ParentNode)object).getChild(n);
            }
            if (node2 instanceof Element) {
                object = node2;
                node3 = DOMConverter.makeElement((Element)object, document2);
                node.appendChild(node3);
                node = node3;
                continue;
            }
            object = DOMConverter.convert(node2, document2);
            node.appendChild((org.w3c.dom.Node)object);
        }
        return element2;
    }

    private static int[] grow(int[] nArray, int n) {
        if (n < nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length * 2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private static org.w3c.dom.Element makeElement(Element element, org.w3c.dom.Document document2) {
        Object object;
        String string2;
        int n;
        String string3 = element.getNamespaceURI();
        org.w3c.dom.Element element2 = element.getParent() instanceof Document ? document2.getDocumentElement() : (string3.equals("") ? document2.createElement(element.getQualifiedName()) : document2.createElementNS(string3, element.getQualifiedName()));
        int n2 = element.getAttributeCount();
        for (n = 0; n < n2; ++n) {
            Attribute attribute = element.getAttribute(n);
            string2 = attribute.getNamespaceURI();
            if (string2.equals("")) {
                object = document2.createAttribute(attribute.getLocalName());
                element2.setAttributeNode((Attr)object);
            } else {
                object = document2.createAttributeNS(string2, attribute.getQualifiedName());
                element2.setAttributeNodeNS((Attr)object);
            }
            object.setValue(attribute.getValue());
        }
        n = element.getNamespaceDeclarationCount();
        for (int i = 0; i < n; ++i) {
            Object object2;
            string2 = element.getNamespacePrefix(i);
            object = element.getNamespaceURI(string2);
            ParentNode parentNode = element.getParent();
            if (!(parentNode instanceof Element) ? ((String)object).equals("") : ((String)object).equals(((Element)(object2 = (Element)parentNode)).getNamespaceURI(string2))) continue;
            if ("".equals(string2)) {
                object2 = document2.createAttributeNS(XMLNS_NAMESPACE, "xmlns");
                element2.setAttributeNodeNS((Attr)object2);
                object2.setValue((String)object);
                continue;
            }
            object2 = document2.createAttributeNS(XMLNS_NAMESPACE, "xmlns:" + string2);
            element2.setAttributeNodeNS((Attr)object2);
            object2.setValue((String)object);
        }
        return element2;
    }
}

