/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.canonical;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Namespace;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;
import nu.xom.Text;
import nu.xom.XPathContext;
import nu.xom.canonical.CanonicalizationException;
import org.xml.sax.helpers.NamespaceSupport;

public class Canonicalizer {
    private boolean withComments;
    private boolean exclusive = false;
    private CanonicalXMLSerializer serializer;
    private List inclusiveNamespacePrefixes = new ArrayList();
    private static Comparator comparator = new AttributeComparator();
    public static final String CANONICAL_XML = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String CANONICAL_XML_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String EXCLUSIVE_XML_CANONICALIZATION = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String EXCLUSIVE_XML_CANONICALIZATION_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";

    public Canonicalizer(OutputStream outputStream) {
        this(outputStream, true, false);
    }

    public Canonicalizer(OutputStream outputStream, boolean bl) {
        this(outputStream, bl, false);
    }

    private Canonicalizer(OutputStream outputStream, boolean bl, boolean bl2) {
        this.serializer = new CanonicalXMLSerializer(outputStream);
        this.serializer.setLineSeparator("\n");
        this.withComments = bl;
        this.exclusive = bl2;
    }

    public Canonicalizer(OutputStream outputStream, String string2) {
        if (string2 == null) {
            throw new NullPointerException("Null algorithm");
        }
        this.serializer = new CanonicalXMLSerializer(outputStream);
        this.serializer.setLineSeparator("\n");
        if (string2.equals(CANONICAL_XML)) {
            this.withComments = false;
            this.exclusive = false;
        } else if (string2.equals(CANONICAL_XML_WITH_COMMENTS)) {
            this.withComments = true;
            this.exclusive = false;
        } else if (string2.equals(EXCLUSIVE_XML_CANONICALIZATION)) {
            this.withComments = false;
            this.exclusive = true;
        } else if (string2.equals(EXCLUSIVE_XML_CANONICALIZATION_WITH_COMMENTS)) {
            this.withComments = true;
            this.exclusive = true;
        } else {
            throw new CanonicalizationException("Unsupported canonicalization algorithm: " + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Node node) throws IOException {
        if (node instanceof Element) {
            Object object;
            Document document2 = node.getDocument();
            Element element = null;
            if (document2 == null) {
                element = new Element("pseudo");
                new Document(element);
                object = (ParentNode)node;
                while (((Node)object).getParent() != null) {
                    object = ((Node)object).getParent();
                }
                element.appendChild((Node)object);
            }
            try {
                object = node.query(".//. | .//@* | .//namespace::*");
                if (this.exclusive) {
                    String string2;
                    Node node2;
                    int n;
                    HashSet<String> hashSet = new HashSet<String>(((Nodes)object).size());
                    for (n = 0; n < ((Nodes)object).size(); ++n) {
                        node2 = ((Nodes)object).get(n);
                        if (node2 instanceof Element) {
                            string2 = ((Element)node2).getNamespacePrefix();
                            hashSet.add(string2);
                            continue;
                        }
                        if (!(node2 instanceof Attribute) || "".equals(string2 = ((Attribute)node2).getNamespacePrefix())) continue;
                        hashSet.add(string2);
                    }
                    for (n = 0; n < ((Nodes)object).size(); ++n) {
                        node2 = ((Nodes)object).get(n);
                        if (!(node2 instanceof Namespace) || hashSet.contains(string2 = ((Namespace)node2).getPrefix())) continue;
                        ((Nodes)object).remove(n);
                        --n;
                    }
                }
                this.write((Nodes)object);
            }
            finally {
                if (element != null) {
                    element.removeChild(0);
                }
            }
        } else {
            this.serializer.nodes = null;
            this.serializer.write(node);
        }
        this.serializer.flush();
    }

    public final void write(Nodes nodes) throws IOException {
        if (nodes.size() > 0) {
            Document document2 = nodes.get(0).getDocument();
            if (document2 == null) {
                throw new CanonicalizationException("Canonicalization is not defined for detached nodes");
            }
            Nodes nodes2 = this.sort(nodes);
            this.serializer.nodes = nodes2;
            this.serializer.write(document2);
            this.serializer.flush();
        }
    }

    public final void setInclusiveNamespacePrefixList(String string2) throws IOException {
        this.inclusiveNamespacePrefixes.clear();
        if (this.exclusive && string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\r\n", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.inclusiveNamespacePrefixes.add(stringTokenizer.nextToken());
            }
        }
    }

    private Nodes sort(Nodes nodes) {
        Document document2 = nodes.get(0).getDocument();
        if (nodes.size() > 1) {
            Node node;
            Nodes nodes2 = new Nodes();
            ArrayList<Node> arrayList = new ArrayList<Node>(nodes.size());
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            for (int i = 0; i < nodes.size(); ++i) {
                node = nodes.get(i);
                arrayList.add(node);
                if (!(node instanceof Namespace)) continue;
                arrayList2.add(node);
            }
            Canonicalizer.sort(arrayList, arrayList2, nodes2, document2);
            if (!arrayList.isEmpty()) {
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    node = (Node)iterator2.next();
                    if (document2 == node.getDocument()) continue;
                    throw new CanonicalizationException("Cannot canonicalize subsets that contain nodes from more than one document");
                }
            }
            return nodes2;
        }
        return new Nodes(nodes.get(0));
    }

    private static void sort(List list2, List list3, Nodes nodes, ParentNode parentNode) {
        if (list2.isEmpty()) {
            return;
        }
        if (list2.contains(parentNode)) {
            nodes.append(parentNode);
            list2.remove(parentNode);
        }
        int n = parentNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node node = parentNode.getChild(i);
            if (node instanceof Element) {
                Object object;
                Element element = (Element)node;
                if (list2.contains(element)) {
                    nodes.append(element);
                    list2.remove(element);
                }
                if (!list3.isEmpty()) {
                    Iterator iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        Namespace namespace;
                        object = iterator2.next();
                        if (!(object instanceof Namespace) || element != (namespace = (Namespace)object).getParent()) continue;
                        nodes.append(namespace);
                        iterator2.remove();
                    }
                }
                for (int j = 0; j < element.getAttributeCount(); ++j) {
                    object = element.getAttribute(j);
                    if (!list2.contains(object)) continue;
                    nodes.append((Node)object);
                    list2.remove(object);
                    if (!list2.isEmpty()) continue;
                    return;
                }
                Canonicalizer.sort(list2, list3, nodes, element);
                continue;
            }
            if (!list2.contains(node)) continue;
            nodes.append(node);
            list2.remove(node);
            if (!list2.isEmpty()) continue;
            return;
        }
    }

    private class CanonicalXMLSerializer
    extends Serializer {
        private Nodes nodes;
        private NamespaceSupport inScope;
        private final XPathContext xmlcontext = new XPathContext("xml", "http://www.w3.org/XML/1998/namespace");

        CanonicalXMLSerializer(OutputStream outputStream) {
            super(outputStream);
            this.setLineSeparator("\n");
        }

        public final void write(Document document2) throws IOException {
            Node node;
            this.inScope = new NamespaceSupport();
            int n = 0;
            do {
                node = document2.getChild(n);
                if (this.nodes == null || node instanceof Element || this.nodes.contains(node)) {
                    this.writeChild(node);
                    if (node instanceof ProcessingInstruction) {
                        this.breakLine();
                    } else if (node instanceof Comment && Canonicalizer.this.withComments) {
                        this.breakLine();
                    }
                }
                ++n;
            } while (!(node instanceof Element));
            for (int i = n; i < document2.getChildCount(); ++i) {
                Node node2 = document2.getChild(i);
                if (this.nodes != null && !(node2 instanceof Element) && !this.nodes.contains(node2)) continue;
                if (node2 instanceof ProcessingInstruction) {
                    this.breakLine();
                } else if (node2 instanceof Comment && Canonicalizer.this.withComments) {
                    this.breakLine();
                }
                this.writeChild(node2);
            }
            this.flush();
        }

        protected final void write(Element element) throws IOException {
            if (element.getChildCount() == 0) {
                this.writeStartTag(element, false);
                this.writeEndTag(element);
            } else {
                Node node = element;
                boolean bl = false;
                int n = -1;
                int[] nArray = new int[10];
                int n2 = 0;
                nArray[0] = -1;
                while (true) {
                    if (!bl && ((Node)node).getChildCount() > 0) {
                        this.writeStartTag((Element)node, false);
                        node = ((Node)node).getChild(0);
                        n = 0;
                        nArray = this.grow(nArray, ++n2);
                        nArray[n2] = 0;
                        continue;
                    }
                    if (bl) {
                        this.writeEndTag((Element)node);
                        if (node == element) {
                            break;
                        }
                    } else {
                        this.writeChild(node);
                    }
                    bl = false;
                    ParentNode parentNode = node.getParent();
                    if (parentNode.getChildCount() - 1 == n) {
                        node = parentNode;
                        --n2;
                        if (node != element) {
                            n = nArray[n2];
                        }
                        bl = true;
                        continue;
                    }
                    nArray[n2] = ++n;
                    node = parentNode.getChild(n);
                }
            }
        }

        private int[] grow(int[] nArray, int n) {
            if (n < nArray.length) {
                return nArray;
            }
            int[] nArray2 = new int[nArray.length * 2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }

        protected void writeStartTag(Element element, boolean bl) throws IOException {
            String string2;
            Object object;
            Attribute[] attributeArray;
            boolean bl2;
            boolean bl3 = bl2 = this.nodes == null || this.nodes.contains(element);
            if (bl2) {
                this.inScope.pushContext();
                this.writeRaw("<");
                this.writeRaw(element.getQualifiedName());
            }
            TreeMap<Object, String> treeMap = new TreeMap<Object, String>();
            if (this.nodes == null) {
                attributeArray = element.getParent();
                Element element2 = null;
                if (attributeArray instanceof Element) {
                    element2 = (Element)attributeArray;
                }
                for (int i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
                    object = element.getNamespacePrefix(i);
                    string2 = element.getNamespaceURI((String)object);
                    if (string2.equals(this.inScope.getURI((String)object))) continue;
                    if (Canonicalizer.this.exclusive) {
                        if (!this.needToDeclareNamespace(element, (String)object, string2)) continue;
                        treeMap.put(object, string2);
                        continue;
                    }
                    if (string2.equals("")) {
                        if (element2 == null || "".equals(element2.getNamespaceURI(""))) continue;
                        treeMap.put(object, string2);
                        continue;
                    }
                    treeMap.put(object, string2);
                }
                this.writeNamespaceDeclarations(treeMap);
            } else {
                Object object2;
                int n = this.indexOf(element);
                if (n != -1 && "".equals(element.getNamespaceURI())) {
                    ParentNode parentNode = element.getParent();
                    while (parentNode instanceof Element && !this.nodes.contains(parentNode)) {
                        parentNode = parentNode.getParent();
                    }
                    if (parentNode instanceof Element && !"".equals(object2 = ((Element)parentNode).getNamespaceURI(""))) {
                        treeMap.put("", "");
                    }
                }
                for (int i = n + 1; i < this.nodes.size() && (object2 = this.nodes.get(i)) instanceof Namespace; ++i) {
                    object = (Namespace)object2;
                    string2 = ((Namespace)object).getPrefix();
                    String string3 = ((Namespace)object).getValue();
                    if (string3.equals(this.inScope.getURI(string2))) continue;
                    if (Canonicalizer.this.exclusive) {
                        if (!this.needToDeclareNamespace(element, string2, string3)) continue;
                        treeMap.put(string2, string3);
                        continue;
                    }
                    treeMap.put(string2, string3);
                }
                this.writeNamespaceDeclarations(treeMap);
            }
            attributeArray = this.sortAttributes(element);
            for (int i = 0; i < attributeArray.length; ++i) {
                if (this.nodes != null && !this.nodes.contains(attributeArray[i]) && (!attributeArray[i].getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace") || attributeArray[i].getParent() == element)) continue;
                this.write(attributeArray[i]);
            }
            if (bl2) {
                this.writeRaw(">");
            }
        }

        private void writeNamespaceDeclarations(SortedMap sortedMap) throws IOException {
            Iterator iterator2 = sortedMap.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                String string2 = (String)entry.getKey();
                String string3 = (String)entry.getValue();
                this.writeRaw(" ");
                this.writeNamespaceDeclaration(string2, string3);
                this.inScope.declarePrefix(string2, string3);
            }
        }

        private boolean needToDeclareNamespace(Element element, String string2, String string3) {
            boolean bl = this.visiblyUtilized(element, string2, string3);
            if (bl || Canonicalizer.this.inclusiveNamespacePrefixes.contains(string2)) {
                return this.noOutputAncestorUsesPrefix(element, string2, string3);
            }
            return false;
        }

        private boolean visiblyUtilized(Element element, String string2, String string3) {
            boolean bl = false;
            String string4 = element.getNamespacePrefix();
            String string5 = element.getNamespaceURI();
            if (string2.equals(string4) && string5.equals(string3)) {
                bl = true;
            } else {
                for (int i = 0; i < element.getAttributeCount(); ++i) {
                    Attribute attribute = element.getAttribute(i);
                    if (this.nodes != null && !this.nodes.contains(attribute) || !string2.equals(string4 = attribute.getNamespacePrefix())) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        private boolean noOutputAncestorUsesPrefix(Element element, String string2, String string3) {
            ParentNode parentNode = element.getParent();
            if (parentNode instanceof Document && "".equals(string3)) {
                return false;
            }
            while (parentNode != null && !(parentNode instanceof Document)) {
                if (this.nodes == null || this.nodes.contains(parentNode)) {
                    Element element2 = (Element)parentNode;
                    String string4 = element2.getNamespacePrefix();
                    if (string4.equals(string2)) {
                        String string5 = element2.getNamespaceURI(string2);
                        return !string5.equals(string3);
                    }
                    for (int i = 0; i < element2.getAttributeCount(); ++i) {
                        Attribute attribute = element2.getAttribute(i);
                        String string6 = attribute.getNamespacePrefix();
                        if (!string6.equals(string2)) continue;
                        String string7 = element2.getNamespaceURI(string2);
                        return !string7.equals(string3);
                    }
                }
                parentNode = parentNode.getParent();
            }
            return true;
        }

        private int indexOf(Element element) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                if (this.nodes.get(i) != element) continue;
                return i;
            }
            return -1;
        }

        protected void write(Attribute attribute) throws IOException {
            this.writeRaw(" ");
            this.writeRaw(attribute.getQualifiedName());
            this.writeRaw("=\"");
            this.writeRaw(this.prepareAttributeValue(attribute));
            this.writeRaw("\"");
        }

        protected void writeEndTag(Element element) throws IOException {
            if (this.nodes == null || this.nodes.contains(element)) {
                this.writeRaw("</");
                this.writeRaw(element.getQualifiedName());
                this.writeRaw(">");
                this.inScope.popContext();
            }
        }

        private Attribute[] sortAttributes(Element element) {
            Object object;
            TreeMap<String, Attribute> treeMap = new TreeMap<String, Attribute>();
            if (!Canonicalizer.this.exclusive && this.nodes != null && this.nodes.contains(element) && !this.nodes.contains(element.getParent())) {
                Nodes nodes = element.query("ancestor::*/@xml:*", this.xmlcontext);
                if (nodes.size() != 0) {
                    for (int i = nodes.size() - 1; i >= 0; --i) {
                        Attribute attribute = (Attribute)nodes.get(i);
                        String string2 = attribute.getLocalName();
                        if (element.getAttribute(string2, "http://www.w3.org/XML/1998/namespace") != null || treeMap.containsKey(string2)) continue;
                        Element element2 = (Element)attribute.getParent();
                        if (!this.nodes.contains(element2)) {
                            treeMap.put(string2, attribute);
                            continue;
                        }
                        treeMap.put(string2, null);
                    }
                }
                object = treeMap.values().iterator();
                while (object.hasNext()) {
                    if (object.next() != null) continue;
                    object.remove();
                }
            }
            int n = element.getAttributeCount();
            object = new Attribute[n + treeMap.size()];
            for (int i = 0; i < n; ++i) {
                object[i] = element.getAttribute(i);
            }
            Iterator iterator2 = treeMap.values().iterator();
            for (int i = n; i < ((Attribute[])object).length; ++i) {
                object[i] = (Attribute)iterator2.next();
            }
            Arrays.sort(object, comparator);
            return object;
        }

        private String prepareAttributeValue(Attribute attribute) {
            String string2 = attribute.getValue();
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            if (attribute.getType().equals(Attribute.Type.CDATA) || attribute.getType().equals(Attribute.Type.UNDECLARED)) {
                char[] cArray = string2.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    char c = cArray[i];
                    if (c == '\t') {
                        stringBuffer.append("&#x9;");
                        continue;
                    }
                    if (c == '\n') {
                        stringBuffer.append("&#xA;");
                        continue;
                    }
                    if (c == '\r') {
                        stringBuffer.append("&#xD;");
                        continue;
                    }
                    if (c == '\"') {
                        stringBuffer.append("&quot;");
                        continue;
                    }
                    if (c == '&') {
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (c == '<') {
                        stringBuffer.append("&lt;");
                        continue;
                    }
                    stringBuffer.append(c);
                }
            } else {
                char[] cArray = string2.toCharArray();
                boolean bl = false;
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] == ' ') {
                        if (i == cArray.length - 1 || cArray[i + 1] == ' ' || !bl) continue;
                        stringBuffer.append(cArray[i]);
                        continue;
                    }
                    bl = true;
                    if (cArray[i] == '\t') {
                        stringBuffer.append("&#x9;");
                        continue;
                    }
                    if (cArray[i] == '\n') {
                        stringBuffer.append("&#xA;");
                        continue;
                    }
                    if (cArray[i] == '\r') {
                        stringBuffer.append("&#xD;");
                        continue;
                    }
                    if (cArray[i] == '\"') {
                        stringBuffer.append("&quot;");
                        continue;
                    }
                    if (cArray[i] == '&') {
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (cArray[i] == '<') {
                        stringBuffer.append("&lt;");
                        continue;
                    }
                    stringBuffer.append(cArray[i]);
                }
            }
            return stringBuffer.toString();
        }

        protected final void write(Text text2) throws IOException {
            if (this.nodes == null || this.nodes.contains(text2)) {
                String string2 = text2.getValue();
                StringBuffer stringBuffer = new StringBuffer(string2.length());
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (c == '\r') {
                        stringBuffer.append("&#xD;");
                        continue;
                    }
                    if (c == '&') {
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (c == '<') {
                        stringBuffer.append("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        stringBuffer.append("&gt;");
                        continue;
                    }
                    stringBuffer.append(c);
                }
                this.writeRaw(stringBuffer.toString());
            }
        }

        protected final void write(Comment comment2) throws IOException {
            if (Canonicalizer.this.withComments && (this.nodes == null || this.nodes.contains(comment2))) {
                super.write(comment2);
            }
        }

        protected final void write(ProcessingInstruction processingInstruction) throws IOException {
            if (this.nodes == null || this.nodes.contains(processingInstruction)) {
                super.write(processingInstruction);
            }
        }

        protected final void write(DocType docType) {
        }

        public void write(Node node) throws IOException {
            if (node instanceof Document) {
                this.write((Document)node);
            } else if (node instanceof Attribute) {
                this.write((Attribute)node);
            } else if (node instanceof Namespace) {
                this.write((Namespace)node);
            } else {
                this.writeChild(node);
            }
        }

        private void write(Namespace namespace) throws IOException {
            String string2 = namespace.getPrefix();
            String string3 = namespace.getValue();
            this.writeRaw(" xmlns");
            if (!"".equals(string2)) {
                this.writeRaw(":");
                this.writeRaw(string2);
            }
            this.writeRaw("=\"");
            this.writeAttributeValue(string3);
            this.writeRaw("\"");
        }
    }

    private static class AttributeComparator
    implements Comparator {
        private AttributeComparator() {
        }

        public int compare(Object object, Object object2) {
            String string2;
            Attribute attribute = (Attribute)object;
            Attribute attribute2 = (Attribute)object2;
            String string3 = attribute.getNamespaceURI();
            if (string3.equals(string2 = attribute2.getNamespaceURI())) {
                return attribute.getLocalName().compareTo(attribute2.getLocalName());
            }
            if (string3.equals("")) {
                return -1;
            }
            if (string2.equals("")) {
                return 1;
            }
            return string3.compareTo(string2);
        }
    }
}

