/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.HashMap;
import java.util.Map;
import nu.xom.Element;
import nu.xom.NamespaceConflictException;
import nu.xom.Verifier;
import nu.xom.jaxen.NamespaceContext;

public final class XPathContext {
    private Map namespaces = new HashMap();

    public XPathContext(String string2, String string3) {
        this();
        this.addNamespace(string2, string3);
    }

    public XPathContext() {
        this.addNamespace("xml", "http://www.w3.org/XML/1998/namespace");
    }

    public void addNamespace(String string2, String string3) {
        if ("xml".equals(string2) && !"http://www.w3.org/XML/1998/namespace".equals(string3)) {
            throw new NamespaceConflictException("Wrong namespace URI for xml prefix: " + string3);
        }
        if ("".equals(string3)) {
            string3 = null;
        }
        if (string2 == null) {
            throw new NullPointerException("Prefixes used in XPath expressions cannot be null");
        }
        if ("".equals(string2)) {
            throw new NamespaceConflictException("XPath expressions do not use the default namespace");
        }
        Verifier.checkNCName(string2);
        if (string3 == null) {
            this.namespaces.remove(string2);
        } else {
            this.namespaces.put(string2, string3);
        }
    }

    public static XPathContext makeNamespaceContext(Element element) {
        XPathContext xPathContext = new XPathContext();
        xPathContext.namespaces = element.getNamespacePrefixesInScope();
        return xPathContext;
    }

    NamespaceContext getJaxenContext() {
        return new JaxenNamespaceContext();
    }

    public String lookup(String string2) {
        return (String)this.namespaces.get(string2);
    }

    private class JaxenNamespaceContext
    implements NamespaceContext {
        private JaxenNamespaceContext() {
        }

        public String translateNamespacePrefixToUri(String string2) {
            return XPathContext.this.lookup(string2);
        }
    }
}

