/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.IOException;
import java.io.Writer;
import nu.xom.TextWriter;
import nu.xom.XMLException;

final class UnicodeWriter
extends TextWriter {
    UnicodeWriter(Writer writer, String string2) {
        super(writer, string2);
    }

    boolean needsEscaping(char c) {
        return false;
    }

    void writeMarkup(String string2) throws IOException {
        int n;
        if (this.normalize) {
            string2 = this.normalize(string2);
        }
        if ((n = UnicodeWriter.getUnicodeLengthForMarkup(string2)) >= 0) {
            this.out.write(string2);
            if (n > 0) {
                this.column += n;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
        } else {
            int n2 = string2.length();
            for (int i = 0; i < n2; ++i) {
                this.writeMarkup(string2.charAt(i));
            }
        }
    }

    void writeName(String string2) throws IOException {
        if (this.normalize) {
            string2 = this.normalize(string2);
        }
        int n = UnicodeWriter.getUnicodeLengthForName(string2);
        this.out.write(string2);
        this.column += n;
        this.lastCharacterWasSpace = false;
        this.skipFollowingLinefeed = false;
        this.justBroke = false;
    }

    private static int getUnicodeLengthForMarkup(String string2) {
        int n = 0;
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (c <= ' ') {
                return -1;
            }
            if (c >= '\ud800' && c <= '\udbff') continue;
            ++n;
        }
        return n;
    }

    private static int getUnicodeLengthForName(String string2) {
        int n = 0;
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (c >= '\ud800' && c <= '\udbff') continue;
            ++n;
        }
        return n;
    }

    void writeAttributeValue(String string2) throws IOException {
        int n;
        if (this.normalize) {
            string2 = this.normalize(string2);
        }
        if ((n = UnicodeWriter.getUnicodeLengthForAttributeValue(string2)) >= 0) {
            this.out.write(string2);
            if (n > 0) {
                this.column += n;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
        } else {
            int n2 = string2.length();
            for (int i = 0; i < n2; ++i) {
                this.writeAttributeValue(string2.charAt(i));
            }
        }
    }

    private static int getUnicodeLengthForAttributeValue(String string2) {
        int n = 0;
        int n2 = string2.length();
        block38: for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\t': {
                    return -1;
                }
                case '\n': {
                    return -1;
                }
                case '\u000b': 
                case '\f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case '\r': {
                    return -1;
                }
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case ' ': {
                    return -1;
                }
                case '!': {
                    ++n;
                    continue block38;
                }
                case '\"': {
                    return -1;
                }
                case '#': {
                    ++n;
                    continue block38;
                }
                case '$': {
                    ++n;
                    continue block38;
                }
                case '%': {
                    ++n;
                    continue block38;
                }
                case '&': {
                    return -1;
                }
                case '\'': {
                    ++n;
                    continue block38;
                }
                case '(': {
                    ++n;
                    continue block38;
                }
                case ')': {
                    ++n;
                    continue block38;
                }
                case '*': {
                    ++n;
                    continue block38;
                }
                case '+': {
                    ++n;
                    continue block38;
                }
                case ',': {
                    ++n;
                    continue block38;
                }
                case '-': {
                    ++n;
                    continue block38;
                }
                case '.': {
                    ++n;
                    continue block38;
                }
                case '/': {
                    ++n;
                    continue block38;
                }
                case '0': {
                    ++n;
                    continue block38;
                }
                case '1': {
                    ++n;
                    continue block38;
                }
                case '2': {
                    ++n;
                    continue block38;
                }
                case '3': {
                    ++n;
                    continue block38;
                }
                case '4': {
                    ++n;
                    continue block38;
                }
                case '5': {
                    ++n;
                    continue block38;
                }
                case '6': {
                    ++n;
                    continue block38;
                }
                case '7': {
                    ++n;
                    continue block38;
                }
                case '8': {
                    ++n;
                    continue block38;
                }
                case '9': {
                    ++n;
                    continue block38;
                }
                case ':': {
                    ++n;
                    continue block38;
                }
                case ';': {
                    ++n;
                    continue block38;
                }
                case '<': {
                    return -1;
                }
                case '=': {
                    ++n;
                    continue block38;
                }
                case '>': {
                    return -1;
                }
                default: {
                    if (c >= '\ud800' && c <= '\udbff') continue block38;
                    ++n;
                }
            }
        }
        return n;
    }

    void writePCDATA(String string2) throws IOException {
        int n;
        if (this.normalize) {
            string2 = this.normalize(string2);
        }
        if ((n = UnicodeWriter.getUnicodeLengthForPCDATA(string2)) >= 0) {
            this.out.write(string2);
            if (n > 0) {
                this.column += n;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
        } else {
            int n2 = string2.length();
            for (int i = 0; i < n2; ++i) {
                this.writePCDATA(string2.charAt(i));
            }
        }
    }

    private static int getUnicodeLengthForPCDATA(String string2) {
        int n = 0;
        int n2 = string2.length();
        block38: for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\t': {
                    return -1;
                }
                case '\n': {
                    return -1;
                }
                case '\u000b': 
                case '\f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case '\r': {
                    return -1;
                }
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case ' ': {
                    return -1;
                }
                case '!': {
                    ++n;
                    continue block38;
                }
                case '\"': {
                    ++n;
                    continue block38;
                }
                case '#': {
                    ++n;
                    continue block38;
                }
                case '$': {
                    ++n;
                    continue block38;
                }
                case '%': {
                    ++n;
                    continue block38;
                }
                case '&': {
                    return -1;
                }
                case '\'': {
                    ++n;
                    continue block38;
                }
                case '(': {
                    ++n;
                    continue block38;
                }
                case ')': {
                    ++n;
                    continue block38;
                }
                case '*': {
                    ++n;
                    continue block38;
                }
                case '+': {
                    ++n;
                    continue block38;
                }
                case ',': {
                    ++n;
                    continue block38;
                }
                case '-': {
                    ++n;
                    continue block38;
                }
                case '.': {
                    ++n;
                    continue block38;
                }
                case '/': {
                    ++n;
                    continue block38;
                }
                case '0': {
                    ++n;
                    continue block38;
                }
                case '1': {
                    ++n;
                    continue block38;
                }
                case '2': {
                    ++n;
                    continue block38;
                }
                case '3': {
                    ++n;
                    continue block38;
                }
                case '4': {
                    ++n;
                    continue block38;
                }
                case '5': {
                    ++n;
                    continue block38;
                }
                case '6': {
                    ++n;
                    continue block38;
                }
                case '7': {
                    ++n;
                    continue block38;
                }
                case '8': {
                    ++n;
                    continue block38;
                }
                case '9': {
                    ++n;
                    continue block38;
                }
                case ':': {
                    ++n;
                    continue block38;
                }
                case ';': {
                    ++n;
                    continue block38;
                }
                case '<': {
                    return -1;
                }
                case '=': {
                    ++n;
                    continue block38;
                }
                case '>': {
                    return -1;
                }
                default: {
                    if (c >= '\ud800' && c <= '\udbff') continue block38;
                    ++n;
                }
            }
        }
        return n;
    }
}

