/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.UnsupportedEncodingException;
import nu.xom.MalformedURIException;
import nu.xom.Verifier;

class URIUtil {
    URIUtil() {
    }

    static boolean isOpaque(String string2) {
        int n = string2.indexOf(58);
        if (string2.substring(n + 1).startsWith("/")) {
            return false;
        }
        return Verifier.isAlpha(string2.charAt(0));
    }

    static boolean isAbsolute(String string2) {
        int n = string2.indexOf(58);
        return n >= 1;
    }

    static String absolutize(String string2, String string3) {
        if ("".equals(string2) || string2 == null) {
            return string3;
        }
        ParsedURI parsedURI = new ParsedURI(string2);
        if (parsedURI.path.endsWith("/..")) {
            parsedURI.path = parsedURI.path + '/';
        }
        ParsedURI parsedURI2 = new ParsedURI(string3);
        ParsedURI parsedURI3 = new ParsedURI();
        if (parsedURI2.authority != null) {
            parsedURI3.authority = parsedURI2.authority;
            parsedURI3.query = parsedURI2.query;
            parsedURI3.path = URIUtil.removeDotSegments(parsedURI2.path);
        } else {
            if ("".equals(parsedURI2.path)) {
                parsedURI3.path = parsedURI.path;
                parsedURI3.query = parsedURI2.query != null ? parsedURI2.query : parsedURI.query;
            } else {
                if (parsedURI2.path.startsWith("/")) {
                    parsedURI3.path = URIUtil.removeDotSegments(parsedURI2.path);
                } else {
                    parsedURI3.path = URIUtil.merge(parsedURI, parsedURI2.path);
                    parsedURI3.path = URIUtil.removeDotSegments(parsedURI3.path);
                }
                parsedURI3.query = parsedURI2.query;
            }
            parsedURI3.authority = parsedURI.authority;
        }
        parsedURI3.scheme = parsedURI.scheme;
        parsedURI3.fragment = parsedURI2.fragment;
        return parsedURI3.toString();
    }

    private static String merge(ParsedURI parsedURI, String string2) {
        if (parsedURI.authority != null && "".equals(parsedURI.path) && !"".equals(parsedURI.authority)) {
            return "/" + string2;
        }
        int n = parsedURI.path.lastIndexOf(47);
        if (n == -1) {
            return string2;
        }
        String string3 = parsedURI.path.substring(0, n + 1);
        return string3 + string2;
    }

    static String removeDotSegments(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string2.length() > 0) {
            int n;
            if (string2.startsWith("/./")) {
                string2 = '/' + string2.substring(3);
                continue;
            }
            if (string2.equals("/.")) {
                string2 = "/";
                continue;
            }
            if (string2.startsWith("/../")) {
                string2 = '/' + string2.substring(4);
                n = stringBuffer.toString().lastIndexOf(47);
                if (n == -1) continue;
                stringBuffer.setLength(n);
                continue;
            }
            if (string2.equals("/..")) {
                string2 = "/";
                n = stringBuffer.toString().lastIndexOf(47);
                if (n == -1) continue;
                stringBuffer.setLength(n);
                continue;
            }
            n = string2.indexOf(47);
            if (n == 0) {
                n = string2.indexOf(47, 1);
            }
            if (n == -1) {
                stringBuffer.append(string2);
                string2 = "";
                continue;
            }
            stringBuffer.append(string2.substring(0, n));
            string2 = string2.substring(n);
        }
        return stringBuffer.toString();
    }

    static String toURI(String string2) {
        int n = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block97: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case ' ': {
                    stringBuffer.append("%20");
                    continue block97;
                }
                case '!': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '\"': {
                    stringBuffer.append("%22");
                    continue block97;
                }
                case '#': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '$': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '%': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '&': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '\'': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '(': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case ')': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '*': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '+': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case ',': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '-': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '.': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '/': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '0': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '1': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '2': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '3': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '4': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '5': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '6': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '7': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '8': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '9': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case ':': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case ';': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '<': {
                    stringBuffer.append("%3C");
                    continue block97;
                }
                case '=': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '>': {
                    stringBuffer.append("%3E");
                    continue block97;
                }
                case '?': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '@': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'A': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'B': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'C': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'D': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'E': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'F': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'G': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'H': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'I': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'J': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'K': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'L': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'M': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'N': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'O': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'P': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'Q': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'R': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'S': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'T': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'U': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'V': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'W': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'X': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'Y': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'Z': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '[': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '\\': {
                    stringBuffer.append("%5C");
                    continue block97;
                }
                case ']': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '^': {
                    stringBuffer.append("%5E");
                    continue block97;
                }
                case '_': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '`': {
                    stringBuffer.append("%60");
                    continue block97;
                }
                case 'a': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'b': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'c': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'd': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'e': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'f': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'g': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'h': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'i': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'j': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'k': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'l': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'm': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'n': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'o': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'p': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'q': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'r': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 's': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 't': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'u': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'v': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'w': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'x': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'y': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case 'z': {
                    stringBuffer.append(c);
                    continue block97;
                }
                case '{': {
                    stringBuffer.append("%7B");
                    continue block97;
                }
                case '|': {
                    stringBuffer.append("%7C");
                    continue block97;
                }
                case '}': {
                    stringBuffer.append("%7D");
                    continue block97;
                }
                case '~': {
                    stringBuffer.append(c);
                    continue block97;
                }
                default: {
                    stringBuffer.append(URIUtil.percentEscape(c));
                }
            }
        }
        return stringBuffer.toString();
    }

    static String percentEscape(char c) {
        StringBuffer stringBuffer = new StringBuffer(3);
        String string2 = String.valueOf(c);
        try {
            byte[] byArray = string2.getBytes("UTF8");
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append('%');
                String string3 = Integer.toHexString(byArray[i]).toUpperCase();
                if (c < '\u0010') {
                    stringBuffer.append('0');
                    stringBuffer.append(string3);
                    continue;
                }
                stringBuffer.append(string3.substring(string3.length() - 2));
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Broken VM: does not recognize UTF-8 encoding");
        }
    }

    static String relativize(String string2, String string3) {
        ParsedURI parsedURI = new ParsedURI(string2);
        ParsedURI parsedURI2 = new ParsedURI(string3);
        parsedURI.path = URIUtil.removeDotSegments(parsedURI.path);
        if (parsedURI.scheme.equals(parsedURI2.scheme) && parsedURI.authority.equals(parsedURI2.authority)) {
            String string4 = parsedURI.path;
            String string5 = parsedURI2.path;
            while (string4.length() > 1) {
                if (!string5.startsWith(string4 = string4.substring(0, string4.lastIndexOf(47)))) continue;
                return string5.substring(string4.length() + 1);
            }
            return string5;
        }
        return string3;
    }

    static class ParsedURI {
        String scheme;
        String schemeSpecificPart;
        String query;
        String fragment;
        String authority;
        String path = "";

        ParsedURI(String string2) {
            int n = string2.indexOf(58);
            int n2 = string2.lastIndexOf(35);
            int n3 = n2 == -1 ? string2.indexOf(63) : string2.substring(0, n2).indexOf(63);
            if (n != -1) {
                this.scheme = string2.substring(0, n);
            }
            if (n3 == -1 && n2 == -1) {
                this.schemeSpecificPart = string2.substring(n + 1);
            } else if (n3 != -1) {
                if (n3 < n) {
                    MalformedURIException malformedURIException = new MalformedURIException("Unparseable URI");
                    malformedURIException.setData(string2);
                    throw malformedURIException;
                }
                this.schemeSpecificPart = string2.substring(n + 1, n3);
            } else {
                if (n2 < n) {
                    MalformedURIException malformedURIException = new MalformedURIException("Unparseable URI");
                    malformedURIException.setData(string2);
                    throw malformedURIException;
                }
                this.schemeSpecificPart = string2.substring(n + 1, n2);
            }
            if (n2 != -1) {
                this.fragment = string2.substring(n2 + 1);
            }
            if (n3 != -1) {
                this.query = n2 == -1 ? string2.substring(n3 + 1) : string2.substring(n3 + 1, n2);
            }
            if (this.schemeSpecificPart.startsWith("//")) {
                int n4 = 2;
                int n5 = this.schemeSpecificPart.indexOf(47, n4);
                if (n5 == -1) {
                    this.authority = this.schemeSpecificPart.substring(2);
                    this.path = "";
                } else {
                    this.authority = this.schemeSpecificPart.substring(n4, n5);
                    this.path = this.schemeSpecificPart.substring(n5);
                }
            } else {
                this.path = this.schemeSpecificPart;
            }
        }

        ParsedURI() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(30);
            if (this.scheme != null) {
                stringBuffer.append(this.scheme);
                stringBuffer.append(':');
            }
            if (this.schemeSpecificPart != null) {
                stringBuffer.append(this.schemeSpecificPart);
            } else {
                stringBuffer.append("//");
                if (this.authority != null) {
                    stringBuffer.append(this.authority);
                }
                stringBuffer.append(this.path);
            }
            if (this.query != null) {
                stringBuffer.append('?');
                stringBuffer.append(this.query);
            }
            if (this.fragment != null) {
                stringBuffer.append('#');
                stringBuffer.append(this.fragment);
            }
            return stringBuffer.toString();
        }
    }
}

