/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.UnsupportedEncodingException;
import nu.xom.CDATASection;
import nu.xom.Node;
import nu.xom.Verifier;

public class Text
extends Node {
    private byte[] data;

    public Text(String string2) {
        this._setValue(string2);
    }

    public Text(Text text2) {
        this.data = text2.data;
    }

    private Text() {
    }

    static Text build(String string2) {
        Text text2 = new Text();
        try {
            text2.data = string2.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Bad VM! Does not support UTF-8");
        }
        return text2;
    }

    public void setValue(String string2) {
        this._setValue(string2);
    }

    private void _setValue(String string2) {
        if (string2 == null) {
            string2 = "";
        } else {
            Verifier.checkPCDATA(string2);
        }
        try {
            this.data = string2.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Bad VM! Does not support UTF-8");
        }
    }

    public final String getValue() {
        try {
            return new String(this.data, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Bad VM! Does not support UTF-8");
        }
    }

    public final Node getChild(int n) {
        throw new IndexOutOfBoundsException("LeafNodes do not have children");
    }

    public final int getChildCount() {
        return 0;
    }

    public Node copy() {
        if (this.isCDATASection()) {
            return new CDATASection(this);
        }
        return new Text(this);
    }

    public final String toXML() {
        return this.escapeText();
    }

    String escapeText() {
        String string2 = this.getValue();
        int n = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n + 12);
        block52: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\r': {
                    stringBuffer.append("&#x0D;");
                    continue block52;
                }
                case '\u000e': {
                    continue block52;
                }
                case '\u000f': {
                    continue block52;
                }
                case '\u0010': {
                    continue block52;
                }
                case '\u0011': {
                    continue block52;
                }
                case '\u0012': {
                    continue block52;
                }
                case '\u0013': {
                    continue block52;
                }
                case '\u0014': {
                    continue block52;
                }
                case '\u0015': {
                    continue block52;
                }
                case '\u0016': {
                    continue block52;
                }
                case '\u0017': {
                    continue block52;
                }
                case '\u0018': {
                    continue block52;
                }
                case '\u0019': {
                    continue block52;
                }
                case '\u001a': {
                    continue block52;
                }
                case '\u001b': {
                    continue block52;
                }
                case '\u001c': {
                    continue block52;
                }
                case '\u001d': {
                    continue block52;
                }
                case '\u001e': {
                    continue block52;
                }
                case '\u001f': {
                    continue block52;
                }
                case ' ': {
                    stringBuffer.append(' ');
                    continue block52;
                }
                case '!': {
                    stringBuffer.append('!');
                    continue block52;
                }
                case '\"': {
                    stringBuffer.append('\"');
                    continue block52;
                }
                case '#': {
                    stringBuffer.append('#');
                    continue block52;
                }
                case '$': {
                    stringBuffer.append('$');
                    continue block52;
                }
                case '%': {
                    stringBuffer.append('%');
                    continue block52;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block52;
                }
                case '\'': {
                    stringBuffer.append('\'');
                    continue block52;
                }
                case '(': {
                    stringBuffer.append('(');
                    continue block52;
                }
                case ')': {
                    stringBuffer.append(')');
                    continue block52;
                }
                case '*': {
                    stringBuffer.append('*');
                    continue block52;
                }
                case '+': {
                    stringBuffer.append('+');
                    continue block52;
                }
                case ',': {
                    stringBuffer.append(',');
                    continue block52;
                }
                case '-': {
                    stringBuffer.append('-');
                    continue block52;
                }
                case '.': {
                    stringBuffer.append('.');
                    continue block52;
                }
                case '/': {
                    stringBuffer.append('/');
                    continue block52;
                }
                case '0': {
                    stringBuffer.append('0');
                    continue block52;
                }
                case '1': {
                    stringBuffer.append('1');
                    continue block52;
                }
                case '2': {
                    stringBuffer.append('2');
                    continue block52;
                }
                case '3': {
                    stringBuffer.append('3');
                    continue block52;
                }
                case '4': {
                    stringBuffer.append('4');
                    continue block52;
                }
                case '5': {
                    stringBuffer.append('5');
                    continue block52;
                }
                case '6': {
                    stringBuffer.append('6');
                    continue block52;
                }
                case '7': {
                    stringBuffer.append('7');
                    continue block52;
                }
                case '8': {
                    stringBuffer.append('8');
                    continue block52;
                }
                case '9': {
                    stringBuffer.append('9');
                    continue block52;
                }
                case ':': {
                    stringBuffer.append(':');
                    continue block52;
                }
                case ';': {
                    stringBuffer.append(';');
                    continue block52;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block52;
                }
                case '=': {
                    stringBuffer.append('=');
                    continue block52;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block52;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    boolean isText() {
        return true;
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + Text.escapeLineBreaksAndTruncate(this.getValue()) + "]";
    }

    static String escapeLineBreaksAndTruncate(String string2) {
        boolean bl;
        int n = string2.length();
        boolean bl2 = bl = n > 40;
        if (n > 40) {
            n = 35;
            string2 = string2.substring(0, 35);
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        block5: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block5;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block5;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        if (bl) {
            stringBuffer.append("...");
        }
        return stringBuffer.toString();
    }

    boolean isCDATASection() {
        return false;
    }

    boolean isEmpty() {
        return this.data.length == 0;
    }
}

