/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.IllegalDataException;
import nu.xom.IllegalNameException;
import nu.xom.IllegalTargetException;
import nu.xom.Node;
import nu.xom.Text;
import nu.xom.Verifier;

public class ProcessingInstruction
extends Node {
    private String target;
    private String data;

    public ProcessingInstruction(String string2, String string3) {
        this._setTarget(string2);
        this._setValue(string3);
    }

    public ProcessingInstruction(ProcessingInstruction processingInstruction) {
        this.target = processingInstruction.target;
        this.data = processingInstruction.data;
    }

    private ProcessingInstruction() {
    }

    static ProcessingInstruction build(String string2, String string3) {
        ProcessingInstruction processingInstruction = new ProcessingInstruction();
        processingInstruction.target = string2;
        processingInstruction.data = string3;
        return processingInstruction;
    }

    public final String getTarget() {
        return this.target;
    }

    public void setTarget(String string2) {
        this._setTarget(string2);
    }

    private void _setTarget(String string2) {
        try {
            Verifier.checkNCName(string2);
        }
        catch (IllegalNameException illegalNameException) {
            IllegalTargetException illegalTargetException = new IllegalTargetException(illegalNameException.getMessage());
            illegalTargetException.setData(string2);
            throw illegalTargetException;
        }
        if (string2.equalsIgnoreCase("xml")) {
            IllegalTargetException illegalTargetException = new IllegalTargetException(string2 + " is not a legal processing instruction target.");
            illegalTargetException.setData(string2);
            throw illegalTargetException;
        }
        this.target = string2;
    }

    public void setValue(String string2) {
        this._setValue(string2);
    }

    private void _setValue(String string2) {
        Verifier.checkPCDATA(string2);
        if (string2.length() != 0) {
            if (string2.indexOf("?>") >= 0) {
                IllegalDataException illegalDataException = new IllegalDataException("Processing instruction data must not contain \"?>\"");
                illegalDataException.setData(string2);
                throw illegalDataException;
            }
            if (string2.indexOf(13) >= 0) {
                IllegalDataException illegalDataException = new IllegalDataException("Processing instruction data cannot contain carriage returns");
                illegalDataException.setData(string2);
                throw illegalDataException;
            }
            char c = string2.charAt(0);
            if (c == ' ' || c == '\n' || c == '\t') {
                IllegalDataException illegalDataException = new IllegalDataException("Processing instruction data cannot contain leading white space");
                illegalDataException.setData(string2);
                throw illegalDataException;
            }
        }
        this.data = string2;
    }

    public final String getValue() {
        return this.data;
    }

    public final Node getChild(int n) {
        throw new IndexOutOfBoundsException("LeafNodes do not have children");
    }

    public final int getChildCount() {
        return 0;
    }

    public final String toXML() {
        StringBuffer stringBuffer = new StringBuffer("<?");
        stringBuffer.append(this.target);
        if (this.data.length() > 0) {
            stringBuffer.append(' ');
            stringBuffer.append(this.data);
        }
        stringBuffer.append("?>");
        return stringBuffer.toString();
    }

    public Node copy() {
        return new ProcessingInstruction(this.target, this.data);
    }

    boolean isProcessingInstruction() {
        return true;
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": target=\"" + this.target + "\"; data=\"" + Text.escapeLineBreaksAndTruncate(this.data) + "\"]";
    }
}

