/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.Element;
import nu.xom.IllegalNameException;
import nu.xom.NamespaceConflictException;
import nu.xom.Node;
import nu.xom.Verifier;

public final class Namespace
extends Node {
    private final String prefix;
    private final String uri;
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";

    public Namespace(String string2, String string3, Element element) {
        if (string2 == null) {
            string2 = "";
        } else {
            if ("xmlns".equals(string2)) {
                throw new IllegalNameException("The xmlns prefix may not be bound to a URI.");
            }
            if ("xml".equals(string2) && !XML_NAMESPACE.equals(string3)) {
                throw new NamespaceConflictException("The prefix xml can only be bound to the URI http://www.w3.org/XML/1998/namespace");
            }
        }
        if (string2.length() != 0) {
            Verifier.checkNCName(string2);
        }
        if (string3 == null) {
            string3 = "";
        } else if (string3.equals(XML_NAMESPACE) && !"xml".equals(string2)) {
            throw new NamespaceConflictException("The URI http://www.w3.org/XML/1998/namespace can only be bound to the prefix xml");
        }
        if (string3.length() == 0) {
            if (string2.length() != 0) {
                throw new NamespaceConflictException("Prefixed elements must have namespace URIs.");
            }
        } else {
            Verifier.checkAbsoluteURIReference(string3);
        }
        this.prefix = string2;
        this.uri = string3;
        super.setParent(element);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getValue() {
        return this.uri;
    }

    public Node getChild(int n) {
        throw new IndexOutOfBoundsException("Namespaces do not have children");
    }

    public int getChildCount() {
        return 0;
    }

    public Node copy() {
        return new Namespace(this.prefix, this.uri, null);
    }

    public void detach() {
        super.setParent(null);
    }

    public String toXML() {
        String string2 = this.prefix.equals("") ? "" : ":";
        return "xmlns" + string2 + this.prefix + "=\"" + this.uri + "\"";
    }

    public String toString() {
        return "[Namespace: " + this.toXML() + "]";
    }
}

