/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.util.Arrays;
import java.util.Iterator;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.SparseVector;
import no.uib.cipr.matrix.sparse.SuperIterator;

public class FlexCompColMatrix
extends AbstractMatrix {
    SparseVector[] colD;

    public FlexCompColMatrix(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.colD = new SparseVector[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            this.colD[i] = new SparseVector(numRows);
        }
    }

    public FlexCompColMatrix(Matrix A, boolean deep) {
        super(A);
        this.colD = new SparseVector[this.numColumns];
        if (deep) {
            for (int i = 0; i < this.numColumns; ++i) {
                this.colD[i] = new SparseVector(this.numRows);
            }
            this.set(A);
        } else {
            FlexCompColMatrix Ar = (FlexCompColMatrix)A;
            for (int i = 0; i < this.numColumns; ++i) {
                this.colD[i] = Ar.getColumn(i);
            }
        }
    }

    public FlexCompColMatrix(Matrix A) {
        this(A, true);
    }

    public SparseVector getColumn(int i) {
        return this.colD[i];
    }

    public void setColumn(int i, SparseVector x2) {
        if (x2.size() != this.numRows) {
            throw new IllegalArgumentException("New column must be of the same size as existing column");
        }
        this.colD[i] = x2;
    }

    @Override
    public Vector multAdd(double alpha, Vector x2, Vector y) {
        if (!(x2 instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x2, y);
        }
        this.checkMultAdd(x2, y);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y).getData();
        y.scale(1.0 / alpha);
        for (int i = 0; i < this.numColumns; ++i) {
            SparseVector v = this.colD[i];
            int[] index = v.getIndex();
            double[] data2 = v.getData();
            int length = v.getUsed();
            for (int j = 0; j < length; ++j) {
                int n = index[j];
                yd[n] = yd[n] + data2[j] * xd[i];
            }
        }
        return y.scale(alpha);
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x2, Vector y) {
        this.checkTransMultAdd(x2, y);
        for (int i = 0; i < this.numColumns; ++i) {
            y.add(i, alpha * this.colD[i].dot(x2));
        }
        return y;
    }

    @Override
    public void add(int row, int column, double value2) {
        this.colD[column].add(row, value2);
    }

    @Override
    public void set(int row, int column, double value2) {
        this.colD[column].set(row, value2);
    }

    @Override
    public double get(int row, int column) {
        return this.colD[column].get(row);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new ColMatrixIterator();
    }

    @Override
    public FlexCompColMatrix copy() {
        return new FlexCompColMatrix(this);
    }

    @Override
    public FlexCompColMatrix zero() {
        for (int i = 0; i < this.numColumns; ++i) {
            this.colD[i].zero();
        }
        return this;
    }

    public void compact() {
        for (SparseVector v : this.colD) {
            v.compact();
        }
    }

    private static class ColMatrixEntry
    implements MatrixEntry {
        private int column;
        private VectorEntry entry;

        private ColMatrixEntry() {
        }

        public void update(int column, VectorEntry entry) {
            this.column = column;
            this.entry = entry;
        }

        @Override
        public int row() {
            return this.entry.index();
        }

        @Override
        public int column() {
            return this.column;
        }

        @Override
        public double get() {
            return this.entry.get();
        }

        @Override
        public void set(double value2) {
            this.entry.set(value2);
        }
    }

    private class ColMatrixIterator
    implements Iterator<MatrixEntry> {
        private SuperIterator<SparseVector, VectorEntry> iterator;
        private ColMatrixEntry entry;

        private ColMatrixIterator() {
            this.iterator = new SuperIterator(Arrays.asList(FlexCompColMatrix.this.colD));
            this.entry = new ColMatrixEntry();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public MatrixEntry next() {
            Object se = this.iterator.next();
            this.entry.update(((SuperIterator.SuperIteratorEntry)se).index(), (VectorEntry)((SuperIterator.SuperIteratorEntry)se).get());
            return this.entry;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

