/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.AbstractIterativeSolver;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;

public class BiCGstab
extends AbstractIterativeSolver {
    private Vector p;
    private Vector s;
    private Vector phat;
    private Vector shat;
    private Vector t;
    private Vector v;
    private Vector temp;
    private Vector r;
    private Vector rtilde;

    public BiCGstab(Vector template) {
        this.p = template.copy();
        this.s = template.copy();
        this.phat = template.copy();
        this.shat = template.copy();
        this.t = template.copy();
        this.v = template.copy();
        this.temp = template.copy();
        this.r = template.copy();
        this.rtilde = template.copy();
    }

    @Override
    public Vector solve(Matrix A, Vector b, Vector x2) throws IterativeSolverNotConvergedException {
        this.checkSizes(A, b, x2);
        double rho_1 = 1.0;
        double rho_2 = 1.0;
        double alpha = 1.0;
        double beta = 1.0;
        double omega = 1.0;
        A.multAdd(-1.0, x2, this.r.set(b));
        this.rtilde.set(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x2)) {
            rho_1 = this.rtilde.dot(this.r);
            if (rho_1 == 0.0) {
                throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (omega == 0.0) {
                throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Breakdown, "omega", this.iter);
            }
            if (this.iter.isFirst()) {
                this.p.set(this.r);
            } else {
                beta = rho_1 / rho_2 * (alpha / omega);
                this.temp.set(-omega, this.v).add(this.p);
                this.p.set(this.r).add(beta, this.temp);
            }
            this.M.apply(this.p, this.phat);
            A.mult(this.phat, this.v);
            alpha = rho_1 / this.rtilde.dot(this.v);
            this.s.set(this.r).add(-alpha, this.v);
            if (this.iter.converged(this.s, x2)) {
                return x2.add(alpha, this.phat);
            }
            this.M.apply(this.s, this.shat);
            A.mult(this.shat, this.t);
            omega = this.t.dot(this.s) / this.t.dot(this.t);
            x2.add(alpha, this.phat);
            x2.add(omega, this.shat);
            this.r.set(this.s).add(-omega, this.t);
            rho_2 = rho_1;
            this.iter.next();
        }
        return x2;
    }
}

