/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.IterationMonitor;
import no.uib.cipr.matrix.sparse.IterationReporter;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;
import no.uib.cipr.matrix.sparse.NoIterationReporter;

public abstract class AbstractIterationMonitor
implements IterationMonitor {
    protected int iter;
    protected Vector.Norm normType = Vector.Norm.Two;
    protected IterationReporter reporter = new NoIterationReporter();
    protected double residual;

    @Override
    public void setFirst() {
        this.iter = 0;
    }

    @Override
    public boolean isFirst() {
        return this.iter == 0;
    }

    @Override
    public void next() {
        ++this.iter;
    }

    @Override
    public int iterations() {
        return this.iter;
    }

    @Override
    public boolean converged(Vector r, Vector x2) throws IterativeSolverNotConvergedException {
        return this.converged(r.norm(this.normType), x2);
    }

    @Override
    public boolean converged(double r, Vector x2) throws IterativeSolverNotConvergedException {
        this.reporter.monitor(r, x2, this.iter);
        this.residual = r;
        return this.convergedI(r, x2);
    }

    @Override
    public boolean converged(double r) throws IterativeSolverNotConvergedException {
        this.reporter.monitor(r, this.iter);
        this.residual = r;
        return this.convergedI(r);
    }

    protected abstract boolean convergedI(double var1, Vector var3) throws IterativeSolverNotConvergedException;

    protected abstract boolean convergedI(double var1) throws IterativeSolverNotConvergedException;

    @Override
    public boolean converged(Vector r) throws IterativeSolverNotConvergedException {
        return this.converged(r.norm(this.normType));
    }

    @Override
    public Vector.Norm getNormType() {
        return this.normType;
    }

    @Override
    public void setNormType(Vector.Norm normType) {
        this.normType = normType;
    }

    @Override
    public IterationReporter getIterationReporter() {
        return this.reporter;
    }

    @Override
    public void setIterationReporter(IterationReporter monitor) {
        this.reporter = monitor;
    }

    @Override
    public double residual() {
        return this.residual;
    }
}

