/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.io;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import no.uib.cipr.matrix.io.MatrixInfo;
import no.uib.cipr.matrix.io.MatrixSize;
import no.uib.cipr.matrix.io.VectorInfo;
import no.uib.cipr.matrix.io.VectorSize;

public class MatrixVectorWriter
extends PrintWriter {
    public MatrixVectorWriter(OutputStream out) {
        super(out);
    }

    public MatrixVectorWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public MatrixVectorWriter(Writer out) {
        super(out);
    }

    public MatrixVectorWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public void add(int num2, int[] indices) {
        int i = 0;
        while (i < indices.length) {
            int n = i++;
            indices[n] = indices[n] + num2;
        }
    }

    public void printMatrixInfo(MatrixInfo info) {
        this.print(info.toString());
    }

    public void printVectorInfo(VectorInfo info) {
        this.print(info.toString());
    }

    public void printMatrixSize(MatrixSize size2, MatrixInfo info) {
        this.format("%10d %10d", size2.numRows(), size2.numColumns());
        if (info.isCoordinate()) {
            this.format(" %19d", size2.numEntries());
        }
        this.println();
    }

    public void printMatrixSize(MatrixSize size2) {
        this.format("%10d %10d %19d\n", size2.numRows(), size2.numColumns(), size2.numEntries());
    }

    public void printVectorSize(VectorSize size2, VectorInfo info) {
        this.format("%10d", size2.size());
        if (info.isCoordinate()) {
            this.format(" %19d", size2.numEntries());
        }
        this.println();
    }

    public void printVectorSize(VectorSize size2) {
        this.format("%10d %19d\n", size2.size(), size2.numEntries());
    }

    public void printArray(float[] data2) {
        for (int i = 0; i < data2.length; ++i) {
            this.format("% .12e\n", Float.valueOf(data2[i]));
        }
    }

    public void printArray(double[] data2) {
        for (int i = 0; i < data2.length; ++i) {
            this.format("% .12e\n", data2[i]);
        }
    }

    public void printArray(float[] dataR, float[] dataI) {
        int size2 = dataR.length;
        if (size2 != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("% .12e % .12e\n", Float.valueOf(dataR[i]), Float.valueOf(dataI[i]));
        }
    }

    public void printArray(double[] dataR, double[] dataI) {
        int size2 = dataR.length;
        if (size2 != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("% .12e % .12e\n", dataR[i], dataI[i]);
        }
    }

    public void printArray(int[] data2) {
        for (int i = 0; i < data2.length; ++i) {
            this.format("%10d\n", data2[i]);
        }
    }

    public void printArray(long[] data2) {
        for (int i = 0; i < data2.length; ++i) {
            this.format("%10d\n", data2[i]);
        }
    }

    public void printCoordinate(int[] index, float[] data2, int offset) {
        int size2 = index.length;
        if (size2 != data2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("%10d % .12e\n", index[i] + offset, Float.valueOf(data2[i]));
        }
    }

    public void printCoordinate(int[] index, double[] data2, int offset) {
        int size2 = index.length;
        if (size2 != data2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("%10d % .12e\n", index[i] + offset, data2[i]);
        }
    }

    public void printCoordinate(int[] index, int[] data2, int offset) {
        int size2 = index.length;
        if (size2 != data2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("%10d %10d\n", index[i] + offset, data2[i]);
        }
    }

    public void printCoordinate(int[] index, long[] data2, int offset) {
        int size2 = index.length;
        if (size2 != data2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("%10d %10d\n", index[i] + offset, data2[i]);
        }
    }

    public void printCoordinate(int[] row, int[] column, float[] data2, int offset) {
        int size2 = row.length;
        if (size2 != column.length || size2 != data2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("%10d %10d % .12e\n", row[i] + offset, column[i] + offset, Float.valueOf(data2[i]));
        }
    }

    public void printCoordinate(int[] row, int[] column, double[] data2, int offset) {
        int size2 = row.length;
        if (size2 != column.length || size2 != data2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("%10d %10d % .12e\n", row[i] + offset, column[i] + offset, data2[i]);
        }
    }

    public void printCoordinate(int[] index, float[] dataR, float[] dataI, int offset) {
        int size2 = index.length;
        if (size2 != dataR.length || size2 != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("%10d % .12e % .12e\n", index[i] + offset, Float.valueOf(dataR[i]), Float.valueOf(dataI[i]));
        }
    }

    public void printCoordinate(int[] index, double[] dataR, double[] dataI, int offset) {
        int size2 = index.length;
        if (size2 != dataR.length || size2 != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("%10d % .12e % .12e\n", index[i] + offset, dataR[i], dataI[i]);
        }
    }

    public void printCoordinate(int[] row, int[] column, float[] dataR, float[] dataI, int offset) {
        int size2 = row.length;
        if (size2 != column.length || size2 != dataR.length || size2 != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("%10d %10d % .12e % .12e\n", row[i] + offset, column[i] + offset, Float.valueOf(dataR[i]), Float.valueOf(dataI[i]));
        }
    }

    public void printCoordinate(int[] row, int[] column, double[] dataR, double[] dataI, int offset) {
        int size2 = row.length;
        if (size2 != column.length || size2 != dataR.length || size2 != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("%10d %10d % .12e % .12e\n", row[i] + offset, column[i] + offset, dataR[i], dataI[i]);
        }
    }

    public void printCoordinate(int[] row, int[] column, int[] data2, int offset) {
        int size2 = row.length;
        if (size2 != column.length || size2 != data2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("%10d %10d %19d\n", row[i] + offset, column[i] + offset, data2[i]);
        }
    }

    public void printCoordinate(int[] row, int[] column, long[] data2, int offset) {
        int size2 = row.length;
        if (size2 != column.length || size2 != data2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("%10d %10d %19d\n", row[i] + offset, column[i] + offset, data2[i]);
        }
    }

    public void printPattern(int[] row, int[] column, int offset) {
        int size2 = row.length;
        if (size2 != column.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < size2; ++i) {
            this.format("%10d %10d\n", row[i] + offset, column[i] + offset);
        }
    }

    public void printPattern(int[] index, int offset) {
        int size2 = index.length;
        for (int i = 0; i < size2; ++i) {
            this.format("%10d\n", index[i] + offset);
        }
    }

    public void printCoordinate(int[] row, int[] column, float[] data2) {
        this.printCoordinate(row, column, data2, 0);
    }

    public void printCoordinate(int[] row, int[] column, double[] data2) {
        this.printCoordinate(row, column, data2, 0);
    }

    public void printCoordinate(int[] row, int[] column, float[] dataR, float[] dataI) {
        this.printCoordinate(row, column, dataR, dataI, 0);
    }

    public void printCoordinate(int[] row, int[] column, double[] dataR, double[] dataI) {
        this.printCoordinate(row, column, dataR, dataI, 0);
    }

    public void printCoordinate(int[] row, int[] column, int[] data2) {
        this.printCoordinate(row, column, data2, 0);
    }

    public void printCoordinate(int[] row, int[] column, long[] data2) {
        this.printCoordinate(row, column, data2, 0);
    }

    public void printPattern(int[] row, int[] column) {
        this.printPattern(row, column, 0);
    }

    public void printCoordinate(int[] index, float[] data2) {
        this.printCoordinate(index, data2, 0);
    }

    public void printCoordinate(int[] index, double[] data2) {
        this.printCoordinate(index, data2, 0);
    }

    public void printCoordinate(int[] index, float[] dataR, float[] dataI) {
        this.printCoordinate(index, dataR, dataI, 0);
    }

    public void printCoordinate(int[] index, double[] dataR, double[] dataI) {
        this.printCoordinate(index, dataR, dataI, 0);
    }

    public void printCoordinate(int[] index, int[] data2) {
        this.printCoordinate(index, data2, 0);
    }

    public void printCoordinate(int[] index, long[] data2) {
        this.printCoordinate(index, data2, 0);
    }

    public void printPattern(int[] index) {
        this.printPattern(index, 0);
    }

    public void printComments(String[] comments) {
        for (String comment2 : comments) {
            this.println("%" + comment2);
        }
    }
}

