/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.distributed;

import java.util.concurrent.Future;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.distributed.Communicator;
import no.uib.cipr.matrix.distributed.DistVector;

@Deprecated
class VectorScatter {
    private final Communicator comm;
    private final Future[] t;
    private final double[][] recvD;
    private final int[][] recvI;
    private final int[][] sendI;
    private final double[][] sendD;
    private final boolean[] send;
    private final boolean[] recv;

    public VectorScatter(Communicator comm, int[][] sendI, int[][] recvI) {
        int i;
        this.comm = comm;
        this.sendI = sendI;
        this.recvI = recvI;
        if (sendI[comm.rank()].length != 0) {
            throw new IllegalArgumentException("Illegal local send detected");
        }
        if (recvI[comm.rank()].length != 0) {
            throw new IllegalArgumentException("Illegal local recv detected");
        }
        this.t = new Future[2 * comm.size()];
        this.sendD = new double[comm.size()][];
        this.recvD = new double[comm.size()][];
        for (i = 0; i < comm.size(); ++i) {
            this.sendD[i] = new double[sendI[i].length];
            this.recvD[i] = new double[recvI[i].length];
        }
        this.send = new boolean[comm.size()];
        this.recv = new boolean[comm.size()];
        for (i = 0; i < comm.size(); ++i) {
            this.send[i] = sendI[i].length > 0;
            this.recv[i] = recvI[i].length > 0;
        }
    }

    public void startScatter(DistVector x2, Vector y) {
        int i;
        if (x2.size() != y.size()) {
            throw new IllegalArgumentException("Vectors must be of the same global size");
        }
        for (i = 0; i < this.comm.size(); ++i) {
            if (i == this.comm.rank()) continue;
            for (int j = 0; j < this.sendI[i].length; ++j) {
                this.sendD[i][j] = x2.get(this.sendI[i][j]);
            }
        }
        for (i = 0; i < this.comm.size(); ++i) {
            if (i == this.comm.rank()) continue;
            if (this.send[i]) {
                this.t[i] = this.comm.isend(this.sendD[i], i);
            }
            if (!this.recv[i]) continue;
            this.t[i + this.comm.size()] = this.comm.irecv(this.recvD[i], i);
        }
    }

    public void endSetScatter(DistVector x2, Vector y) {
        if (x2.size() != y.size()) {
            throw new IllegalArgumentException("Vectors must be of the same global size");
        }
        this.comm.await(this.t);
        for (int i = 0; i < this.comm.size(); ++i) {
            if (i == this.comm.rank()) continue;
            for (int j = 0; j < this.recvI[i].length; ++j) {
                y.set(this.recvI[i][j], this.recvD[i][j]);
            }
        }
    }

    public void endAddScatter(DistVector x2, Vector y) {
        if (x2.size() != y.size()) {
            throw new IllegalArgumentException("Vectors must be of the same global size");
        }
        this.comm.await(this.t);
        for (int i = 0; i < this.comm.size(); ++i) {
            if (i == this.comm.rank()) continue;
            for (int j = 0; j < this.recvI[i].length; ++j) {
                y.add(this.recvI[i][j], this.recvD[i][j]);
            }
        }
    }

    public void startGather(Vector x2, DistVector y) {
        int i;
        if (x2.size() != y.size()) {
            throw new IllegalArgumentException("Vectors must be of the same global size");
        }
        for (i = 0; i < this.comm.size(); ++i) {
            if (i == this.comm.rank()) continue;
            for (int j = 0; j < this.recvI[i].length; ++j) {
                this.recvD[i][j] = x2.get(this.recvI[i][j]);
            }
        }
        for (i = 0; i < this.comm.size(); ++i) {
            if (i == this.comm.rank()) continue;
            if (this.send[i]) {
                this.t[i] = this.comm.isend(this.recvD[i], i);
            }
            if (!this.recv[i]) continue;
            this.t[i + this.comm.size()] = this.comm.irecv(this.sendD[i], i);
        }
    }

    public void endSetGather(Vector x2, DistVector y) {
        if (x2.size() != y.size()) {
            throw new IllegalArgumentException("Vectors must be of the same global size");
        }
        this.comm.await(this.t);
        for (int i = 0; i < this.comm.size(); ++i) {
            if (i == this.comm.rank()) continue;
            for (int j = 0; j < this.sendI[i].length; ++j) {
                y.set(this.sendI[i][j], this.sendD[i][j]);
            }
        }
    }

    public void endAddGather(Vector x2, DistVector y) {
        if (x2.size() != y.size()) {
            throw new IllegalArgumentException("Vectors must be of the same global size");
        }
        this.comm.await(this.t);
        for (int i = 0; i < this.comm.size(); ++i) {
            if (i == this.comm.rank()) continue;
            for (int j = 0; j < this.sendI[i].length; ++j) {
                y.add(this.sendI[i][j], this.sendD[i][j]);
            }
        }
    }
}

