/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.LowerTriangBandMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;

public class UnitLowerTriangBandMatrix
extends LowerTriangBandMatrix {
    public UnitLowerTriangBandMatrix(int n, int kd) {
        super(n, kd, Diag.Unit);
    }

    public UnitLowerTriangBandMatrix(Matrix A, int kd) {
        this(A, kd, true);
    }

    public UnitLowerTriangBandMatrix(Matrix A, int kd, boolean deep) {
        super(A, kd, deep, Diag.Unit);
    }

    @Override
    public void add(int row, int column, double value2) {
        if (row == column) {
            throw new IllegalArgumentException("row == column");
        }
        super.add(row, column, value2);
    }

    @Override
    public double get(int row, int column) {
        if (row == column) {
            return 1.0;
        }
        return super.get(row, column);
    }

    @Override
    public void set(int row, int column, double value2) {
        if (row == column) {
            throw new IllegalArgumentException("row == column");
        }
        super.set(row, column, value2);
    }

    @Override
    public UnitLowerTriangBandMatrix copy() {
        return new UnitLowerTriangBandMatrix(this, this.kl);
    }

    @Override
    public Matrix zero() {
        throw new UnsupportedOperationException();
    }

    @Override
    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (!this.inBand(e.row(), e.column()) || e.row() == e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }
}

