/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.JobEig;
import no.uib.cipr.matrix.JobEigRange;
import no.uib.cipr.matrix.LowerSymmDenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmEVD;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.UpperSymmDenseMatrix;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class SymmDenseEVD
extends SymmEVD {
    private final double[] work;
    private final int[] iwork;
    private final UpLo uplo;
    private final JobEigRange range;
    private final int[] isuppz;
    private final double abstol;

    public SymmDenseEVD(int n, boolean upper) {
        this(n, upper, true, LAPACK.getInstance().dlamch("Safe minimum"));
    }

    public SymmDenseEVD(int n, boolean upper, double abstol) {
        this(n, upper, true, abstol);
    }

    public SymmDenseEVD(int n, boolean upper, boolean vectors) {
        this(n, upper, vectors, LAPACK.getInstance().dlamch("Safe minimum"));
    }

    public SymmDenseEVD(int n, boolean upper, boolean vectors, double abstol) {
        super(n, vectors);
        this.abstol = abstol;
        this.uplo = upper ? UpLo.Upper : UpLo.Lower;
        this.range = JobEigRange.All;
        this.isuppz = new int[2 * Math.max(1, n)];
        double[] worksize = new double[1];
        int[] iworksize = new int[1];
        intW info = new intW(0);
        LAPACK.getInstance().dsyevr(this.job.netlib(), this.range.netlib(), this.uplo.netlib(), n, new double[0], Matrices.ld(n), 0.0, 0.0, 0, 0, abstol, new intW(1), new double[0], new double[0], Matrices.ld(n), this.isuppz, worksize, -1, iworksize, -1, info);
        int lwork = 0;
        int liwork = 0;
        if (info.val != 0) {
            lwork = 26 * n;
            liwork = 10 * n;
        } else {
            lwork = (int)worksize[0];
            liwork = iworksize[0];
        }
        lwork = Math.max(1, lwork);
        liwork = Math.max(1, liwork);
        this.work = new double[lwork];
        this.iwork = new int[liwork];
    }

    public static SymmDenseEVD factorize(Matrix A) throws NotConvergedException {
        return new SymmDenseEVD(A.numRows(), true).factor(new UpperSymmDenseMatrix(A));
    }

    public SymmDenseEVD factor(LowerSymmDenseMatrix A) throws NotConvergedException {
        if (this.uplo != UpLo.Lower) {
            throw new IllegalArgumentException("Eigenvalue computer configured for lower-symmetrical matrices");
        }
        return this.factor(A, A.getData());
    }

    public SymmDenseEVD factor(UpperSymmDenseMatrix A) throws NotConvergedException {
        if (this.uplo != UpLo.Upper) {
            throw new IllegalArgumentException("Eigenvalue computer configured for upper-symmetrical matrices");
        }
        return this.factor(A, A.getData());
    }

    private SymmDenseEVD factor(Matrix A, double[] data2) throws NotConvergedException {
        if (A.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dsyevr(this.job.netlib(), this.range.netlib(), this.uplo.netlib(), this.n, data2, Matrices.ld(this.n), 0.0, 0.0, 0, 0, this.abstol, new intW(1), this.w, this.job == JobEig.All ? this.Z.getData() : new double[]{}, Matrices.ld(this.n), this.isuppz, this.work, this.work.length, this.iwork, this.iwork.length, info);
        if (info.val > 0) {
            throw new NotConvergedException(NotConvergedException.Reason.Iterations);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return this;
    }
}

