/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Arrays;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.AbstractVector;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;

public final class Matrices {
    private Matrices() {
    }

    static int ld(int n) {
        return Math.max(1, n);
    }

    static int ld(int m, int n) {
        return Math.max(1, Math.max(m, n));
    }

    public static int cardinality(Vector x2) {
        int nz = 0;
        for (VectorEntry e : x2) {
            if (e.get() == 0.0) continue;
            ++nz;
        }
        return nz;
    }

    public static int cardinality(Matrix A) {
        int nz = 0;
        for (MatrixEntry e : A) {
            if (e.get() == 0.0) continue;
            ++nz;
        }
        return nz;
    }

    public static double[][] getArray(Matrix A) {
        double[][] Ad = new double[A.numRows()][A.numColumns()];
        for (MatrixEntry e : A) {
            Ad[e.row()][e.column()] = e.get();
        }
        return Ad;
    }

    public static double[] getArray(Vector x2) {
        double[] xd = new double[x2.size()];
        for (VectorEntry e : x2) {
            xd[e.index()] = e.get();
        }
        return xd;
    }

    public static DenseMatrix identity(int size2) {
        DenseMatrix A = new DenseMatrix(size2, size2);
        for (int i = 0; i < size2; ++i) {
            A.set(i, i, 1.0);
        }
        return A;
    }

    public static Vector random(int size2) {
        return Matrices.random(new DenseVector(size2));
    }

    public static Vector random(Vector x2) {
        for (int i = 0; i < x2.size(); ++i) {
            x2.set(i, Math.random());
        }
        return x2;
    }

    public static Matrix random(int numRows, int numColumns) {
        return Matrices.random(new DenseMatrix(numRows, numColumns));
    }

    public static Matrix random(Matrix A) {
        for (int j = 0; j < A.numColumns(); ++j) {
            for (int i = 0; i < A.numRows(); ++i) {
                A.set(i, j, Math.random());
            }
        }
        return A;
    }

    public static Vector synchronizedVector(Vector x2) {
        return new SynchronizedVector(x2);
    }

    public static Matrix synchronizedMatrix(Matrix A) {
        return new SynchronizedMatrix(A);
    }

    public static Matrix synchronizedMatrixByRows(Matrix A) {
        return new SynchronizedRowMatrix(A);
    }

    public static Matrix synchronizedMatrixByColumns(Matrix A) {
        return new SynchronizedColumnMatrix(A);
    }

    public static Matrix getSubMatrix(Matrix A, int[] row, int[] column) {
        return new RefMatrix(A, row, column);
    }

    public static Vector getSubVector(Vector x2, int[] index) {
        return new RefVector(x2, index);
    }

    public static int[] index(int from2, int to2) {
        int length = to2 - from2;
        if (length < 0) {
            length = 0;
        }
        int[] index = new int[length];
        int i = from2;
        for (int j = 0; j < length; ++j) {
            index[j] = i++;
        }
        return index;
    }

    public static int[] index(int from2, int stride, int to2) {
        if (stride == 1) {
            return Matrices.index(from2, to2);
        }
        if (stride == 0) {
            return new int[0];
        }
        if (to2 <= from2 && stride > 0) {
            return new int[0];
        }
        if (from2 <= to2 && stride < 0) {
            return new int[0];
        }
        int length = Math.abs((to2 - from2) / stride);
        if (Math.abs((to2 - from2) % stride) > 0) {
            ++length;
        }
        if (length < 0) {
            length = 0;
        }
        int[] index = new int[length];
        int i = from2;
        for (int j = 0; j < length; ++j) {
            index[j] = i;
            i += stride;
        }
        return index;
    }

    public static int[] rowBandwidth(Matrix A) {
        int[] nz = new int[A.numRows()];
        for (MatrixEntry e : A) {
            int n = e.row();
            nz[n] = nz[n] + 1;
        }
        return nz;
    }

    public static int[] columnBandwidth(Matrix A) {
        int[] nz = new int[A.numColumns()];
        for (MatrixEntry e : A) {
            int n = e.column();
            nz[n] = nz[n] + 1;
        }
        return nz;
    }

    public static int getNumSubDiagonals(Matrix A) {
        int kl = 0;
        for (MatrixEntry e : A) {
            kl = Math.max(kl, e.row() - e.column());
        }
        return kl;
    }

    public static int getNumSuperDiagonals(Matrix A) {
        int ku = 0;
        for (MatrixEntry e : A) {
            ku = Math.max(ku, e.column() - e.row());
        }
        return ku;
    }

    public static void zeroRows(Matrix A, double diagonal, int ... row) {
        int[] rowS = (int[])row.clone();
        Arrays.sort(rowS);
        for (MatrixEntry e : A) {
            int j = Arrays.binarySearch(rowS, e.row());
            if (j < 0) continue;
            if (e.row() == e.column()) {
                e.set(diagonal);
                continue;
            }
            e.set(0.0);
        }
        if (diagonal != 0.0) {
            for (int rowI : row) {
                A.set(rowI, rowI, diagonal);
            }
        }
    }

    public static void zeroColumns(Matrix A, double diagonal, int ... column) {
        int[] columnS = (int[])column.clone();
        Arrays.sort(columnS);
        for (MatrixEntry e : A) {
            int j = Arrays.binarySearch(columnS, e.column());
            if (j < 0) continue;
            if (e.row() == e.column()) {
                e.set(diagonal);
                continue;
            }
            e.set(0.0);
        }
        if (diagonal != 0.0) {
            for (int columnI : column) {
                A.set(columnI, columnI, diagonal);
            }
        }
    }

    private static class SynchronizedColumnMatrix
    extends AbstractMatrix {
        private Matrix A;
        private Object[] lock;

        public SynchronizedColumnMatrix(Matrix A) {
            super(A);
            this.A = A;
            this.lock = new Object[A.numColumns()];
            for (int i = 0; i < this.lock.length; ++i) {
                this.lock[i] = new Object();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int row, int column, double value2) {
            Object object = this.lock[column];
            synchronized (object) {
                this.A.add(row, column, value2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(int row, int column, double value2) {
            Object object = this.lock[column];
            synchronized (object) {
                this.A.set(row, column, value2);
            }
        }

        @Override
        public double get(int row, int column) {
            return this.A.get(row, column);
        }

        @Override
        public Matrix copy() {
            return Matrices.synchronizedMatrixByColumns(this.A.copy());
        }
    }

    private static class SynchronizedRowMatrix
    extends AbstractMatrix {
        private Matrix A;
        private Object[] lock;

        public SynchronizedRowMatrix(Matrix A) {
            super(A);
            this.A = A;
            this.lock = new Object[A.numRows()];
            for (int i = 0; i < this.lock.length; ++i) {
                this.lock[i] = new Object();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int row, int column, double value2) {
            Object object = this.lock[row];
            synchronized (object) {
                this.A.add(row, column, value2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(int row, int column, double value2) {
            Object object = this.lock[row];
            synchronized (object) {
                this.A.set(row, column, value2);
            }
        }

        @Override
        public double get(int row, int column) {
            return this.A.get(row, column);
        }

        @Override
        public Matrix copy() {
            return Matrices.synchronizedMatrixByRows(this.A.copy());
        }
    }

    private static class SynchronizedMatrix
    extends AbstractMatrix {
        private Matrix A;

        public SynchronizedMatrix(Matrix A) {
            super(A);
            this.A = A;
        }

        @Override
        public synchronized void add(int row, int column, double value2) {
            this.A.add(row, column, value2);
        }

        @Override
        public synchronized void set(int row, int column, double value2) {
            this.A.set(row, column, value2);
        }

        @Override
        public synchronized double get(int row, int column) {
            return this.A.get(row, column);
        }

        @Override
        public Matrix copy() {
            return Matrices.synchronizedMatrix(this.A.copy());
        }
    }

    private static class SynchronizedVector
    extends AbstractVector {
        private Vector x;

        public SynchronizedVector(Vector x2) {
            super(x2);
            this.x = x2;
        }

        @Override
        public synchronized void add(int index, double value2) {
            this.x.add(index, value2);
        }

        @Override
        public synchronized void set(int index, double value2) {
            this.x.set(index, value2);
        }

        @Override
        public synchronized double get(int index) {
            return this.x.get(index);
        }

        @Override
        public Vector copy() {
            return Matrices.synchronizedVector(this.x.copy());
        }
    }

    private static class RefVector
    extends AbstractVector {
        private Vector x;
        private int[] index;

        public RefVector(Vector x2, int[] index) {
            super(index.length);
            this.x = x2;
            this.index = index;
        }

        @Override
        public void add(int index, double value2) {
            this.x.add(this.index[index], value2);
        }

        @Override
        public DenseVector copy() {
            return new DenseVector(this);
        }

        @Override
        public double get(int index) {
            return this.x.get(this.index[index]);
        }

        @Override
        public void set(int index, double value2) {
            this.x.set(this.index[index], value2);
        }
    }

    private static class RefMatrix
    extends AbstractMatrix {
        private Matrix A;
        private int[] row;
        private int[] column;

        public RefMatrix(Matrix A, int[] row, int[] column) {
            super(row.length, column.length);
            this.A = A;
            this.row = row;
            this.column = column;
        }

        @Override
        public void add(int row, int column, double value2) {
            this.A.add(this.row[row], this.column[column], value2);
        }

        @Override
        public DenseMatrix copy() {
            return new DenseMatrix(this);
        }

        @Override
        public double get(int row, int column) {
            return this.A.get(this.row[row], this.column[column]);
        }

        @Override
        public void set(int row, int column, double value2) {
            this.A.set(this.row[row], this.column[column], value2);
        }
    }
}

