/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractBandMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.Vector;
import org.netlib.blas.BLAS;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

abstract class AbstractTriangBandMatrix
extends AbstractBandMatrix {
    private UpLo uplo;
    private Diag diag;
    int kd;

    AbstractTriangBandMatrix(int n, int kl, int ku, UpLo uplo, Diag diag) {
        super(n, kl, ku);
        this.kd = Math.max(kl, ku);
        this.uplo = uplo;
        this.diag = diag;
    }

    AbstractTriangBandMatrix(Matrix A, int kl, int ku, UpLo uplo, Diag diag) {
        this(A, kl, ku, true, uplo, diag);
    }

    AbstractTriangBandMatrix(Matrix A, int kl, int ku, boolean deep, UpLo uplo, Diag diag) {
        super(A, kl, ku, deep);
        this.kd = Math.max(kl, ku);
        this.uplo = uplo;
        this.diag = diag;
    }

    @Override
    public Vector mult(double alpha, Vector x2, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.mult(alpha, x2, y);
        }
        this.checkMultAdd(x2, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x2);
        BLAS.getInstance().dtbmv(this.uplo.netlib(), Transpose.NoTranspose.netlib(), this.diag.netlib(), this.numRows, this.kd, this.data, this.kd + 1, yd, 1);
        return y;
    }

    @Override
    public Vector transMult(double alpha, Vector x2, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.transMult(alpha, x2, y);
        }
        this.checkTransMultAdd(x2, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x2);
        BLAS.getInstance().dtbmv(this.uplo.netlib(), Transpose.Transpose.netlib(), this.diag.netlib(), this.numRows, this.kd, this.data, this.kd + 1, yd, 1);
        return y;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X2) {
        return this.solve(B, X2, Transpose.NoTranspose);
    }

    @Override
    public Vector solve(Vector b, Vector x2) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X2 = new DenseMatrix(x2, false);
        this.solve(B, X2);
        return x2;
    }

    @Override
    public Matrix transSolve(Matrix B, Matrix X2) {
        return this.solve(B, X2, Transpose.Transpose);
    }

    @Override
    public Vector transSolve(Vector b, Vector x2) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X2 = new DenseMatrix(x2, false);
        this.transSolve(B, X2);
        return x2;
    }

    Matrix solve(Matrix B, Matrix X2, Transpose trans) {
        if (!(X2 instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X2);
        double[] Xd = ((DenseMatrix)X2).getData();
        X2.set(B);
        intW info = new intW(0);
        LAPACK.getInstance().dtbtrs(this.uplo.netlib(), trans.netlib(), this.diag.netlib(), this.numRows, this.kd, X2.numColumns(), this.data, Matrices.ld(this.kd + 1), Xd, Matrices.ld(this.n), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X2;
    }
}

