/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractPackMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.Vector;
import org.netlib.blas.BLAS;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

abstract class AbstractSymmPackMatrix
extends AbstractPackMatrix {
    private UpLo uplo;

    AbstractSymmPackMatrix(int n, UpLo uplo) {
        super(n);
        this.uplo = uplo;
    }

    AbstractSymmPackMatrix(Matrix A, UpLo uplo) {
        this(A, true, uplo);
    }

    AbstractSymmPackMatrix(Matrix A, boolean deep, UpLo uplo) {
        super(A, deep);
        this.uplo = uplo;
    }

    @Override
    public Vector multAdd(double alpha, Vector x2, Vector y) {
        if (!(x2 instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x2, y);
        }
        this.checkMultAdd(x2, y);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dspmv(this.uplo.netlib(), this.numRows, alpha, this.data, xd, 1, 1.0, yd, 1);
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x2, Vector y) {
        return this.multAdd(alpha, x2, y);
    }

    @Override
    public Matrix rank1(double alpha, Vector x2, Vector y) {
        if (x2 != y) {
            throw new IllegalArgumentException("x != y");
        }
        if (!(x2 instanceof DenseVector)) {
            return super.rank1(alpha, x2, y);
        }
        this.checkRank1(x2, y);
        double[] xd = ((DenseVector)x2).getData();
        BLAS.getInstance().dspr(this.uplo.netlib(), this.numRows, alpha, xd, 1, this.data);
        return this;
    }

    @Override
    public Matrix rank2(double alpha, Vector x2, Vector y) {
        if (!(x2 instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.rank2(alpha, x2, y);
        }
        this.checkRank2(x2, y);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dspr2(this.uplo.netlib(), this.numRows, alpha, xd, 1, yd, 1, this.data);
        return this;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X2) {
        if (!(X2 instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X2);
        double[] Xd = ((DenseMatrix)X2).getData();
        X2.set(B);
        int[] ipiv = new int[this.numRows];
        intW info = new intW(0);
        LAPACK.getInstance().dspsv(this.uplo.netlib(), this.numRows, X2.numColumns(), (double[])this.data.clone(), ipiv, Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X2;
    }

    @Override
    public Vector solve(Vector b, Vector x2) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X2 = new DenseMatrix(x2, false);
        this.solve(B, X2);
        return x2;
    }

    @Override
    public Matrix transSolve(Matrix B, Matrix X2) {
        return this.solve(B, X2);
    }

    @Override
    public Vector transSolve(Vector b, Vector x2) {
        return this.solve(b, x2);
    }

    Matrix SPDsolve(Matrix B, Matrix X2) {
        if (!(X2 instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X2);
        double[] Xd = ((DenseMatrix)X2).getData();
        X2.set(B);
        intW info = new intW(0);
        LAPACK.getInstance().dppsv(this.uplo.netlib(), this.numRows, X2.numColumns(), (double[])this.data.clone(), Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixNotSPDException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X2;
    }

    @Override
    public Matrix transpose() {
        return this;
    }
}

