/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jniinchi;

import net.sf.jniinchi.INCHI_BOND_STEREO;
import net.sf.jniinchi.INCHI_BOND_TYPE;
import net.sf.jniinchi.JniInchiAtom;
import net.sf.jniinchi.JniInchiBond;
import net.sf.jniinchi.JniInchiException;
import net.sf.jniinchi.JniInchiInput;
import net.sf.jniinchi.JniInchiInputInchi;
import net.sf.jniinchi.JniInchiOutput;
import net.sf.jniinchi.JniInchiOutputStructure;
import net.sf.jniinchi.JniInchiStructure;
import net.sf.jniinchi.JniInchiWrapper;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class Main {
    public static JniInchiStructure getTestMolecule() {
        JniInchiStructure struct = new JniInchiStructure();
        JniInchiAtom a1 = struct.addAtom(new JniInchiAtom(264.0, 968.0, 0.0, "C"));
        JniInchiAtom a2 = struct.addAtom(new JniInchiAtom(295.0, 985.0, 0.0, "C"));
        JniInchiAtom a3 = struct.addAtom(new JniInchiAtom(233.0, 986.0, 0.0, "N"));
        JniInchiAtom a4 = struct.addAtom(new JniInchiAtom(264.0, 932.0, 0.0, "C"));
        JniInchiAtom a5 = struct.addAtom(new JniInchiAtom(326.0, 967.0, 0.0, "O"));
        JniInchiAtom a6 = struct.addAtom(new JniInchiAtom(295.0, 1021.0, 0.0, "O"));
        a1.setImplicitH(1);
        a3.setImplicitH(2);
        a4.setImplicitH(3);
        a5.setImplicitH(1);
        struct.addBond(new JniInchiBond(a1, a2, INCHI_BOND_TYPE.SINGLE));
        struct.addBond(new JniInchiBond(a1, a3, INCHI_BOND_TYPE.SINGLE)).setStereoDefinition(INCHI_BOND_STEREO.SINGLE_1DOWN);
        struct.addBond(new JniInchiBond(a1, a4, INCHI_BOND_TYPE.SINGLE));
        struct.addBond(new JniInchiBond(a2, a5, INCHI_BOND_TYPE.SINGLE));
        struct.addBond(new JniInchiBond(a2, a6, INCHI_BOND_TYPE.DOUBLE));
        return struct;
    }

    public static void runChecks() throws JniInchiException {
        System.err.println("Loading native code");
        System.err.println();
        try {
            JniInchiWrapper.loadLibrary();
            System.err.println();
            System.err.println("Native code version: " + JniInchiWrapper.LibInchiGetVersion());
            System.err.println();
            System.err.println("Running checks");
            System.err.println();
            System.err.println("Generating InChI from structure");
            JniInchiStructure mol = Main.getTestMolecule();
            JniInchiOutput out1 = JniInchiWrapper.getInchi(new JniInchiInput(mol));
            if ("InChI=1S/C3H7NO2/c1-2(4)3(5)6/h2H,4H2,1H3,(H,5,6)/t2-/m0/s1".equals(out1.getInchi())) {
                System.err.println(" - OKAY");
            } else {
                System.err.println(" - ERROR");
                System.err.println(out1.getInchi());
            }
            System.err.println("Generating structure from InChI");
            JniInchiOutputStructure out2 = JniInchiWrapper.getStructureFromInchi(new JniInchiInputInchi("InChI=1/C3H7NO2/c1-2(4)3(5)6/h2H,4H2,1H3,(H,5,6)"));
            if (out2.getNumAtoms() == 6 && out2.getNumBonds() == 5) {
                System.err.println(" - OKAY");
            } else {
                System.err.println(" - ERROR");
            }
            System.err.println("Converting structure back to InChI");
            JniInchiOutput out3 = JniInchiWrapper.getInchi(new JniInchiInput(out2));
            if ("InChI=1S/C3H7NO2/c1-2(4)3(5)6/h2H,4H2,1H3,(H,5,6)".equals(out3.getInchi())) {
                System.err.println(" - OKAY");
            } else {
                System.err.println(" - ERROR");
                System.err.println(out3.getInchi());
            }
        }
        catch (Exception e) {
            System.err.println(" - ERROR");
            e.printStackTrace();
        }
        System.err.println();
        System.err.println("Checks done.");
        System.err.println();
    }

    public static void main(String[] args) throws Exception {
        System.err.println();
        System.err.println("** JniInchi debugger **");
        System.err.println();
        Logger root2 = Logger.getRootLogger();
        if (args.length == 1 && "-debug".equals(args[0])) {
            root2.setLevel(Level.ALL);
        } else {
            root2.setLevel(Level.INFO);
        }
        root2.removeAllAppenders();
        PatternLayout layout = new PatternLayout("%-5p %c - %m%n");
        ConsoleAppender aconn = new ConsoleAppender((Layout)layout, "System.err");
        aconn.setThreshold(Level.ALL);
        root2.addAppender(aconn);
        Main.runChecks();
    }
}

