/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy.repository;

import java.io.File;
import java.util.Collections;
import java.util.List;
import net.sf.jnati.NativeCodeException;
import net.sf.jnati.deploy.artefact.Artefact;
import net.sf.jnati.deploy.repository.ArtefactRepository;
import net.sf.jnati.deploy.source.ArtefactSource;
import net.sf.jnati.deploy.source.FileSource;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalRepository
extends ArtefactRepository {
    private static final Logger LOG = Logger.getLogger(LocalRepository.class);
    private static final String FS = "/";
    private final File root;

    public LocalRepository(File root2) {
        this.root = root2;
    }

    private File getPath(Artefact artefact) {
        String path = artefact.getId() + FS + artefact.getVersion() + FS + artefact.getOsArch();
        return new File(this.root, path);
    }

    private File getPath(Artefact artefact, int index) {
        String path = artefact.getId() + FS + artefact.getVersion() + FS + artefact.getOsArch() + "~" + index;
        return new File(this.root, path);
    }

    public boolean containsArtefact(Artefact artefact) {
        File file = this.getPath(artefact);
        return file.isDirectory();
    }

    @Override
    public List<? extends ArtefactSource> getArtefactSource(Artefact artefact) {
        LOG.info("Searching local repository for: " + artefact);
        File path = this.getPath(artefact);
        LOG.debug("Artefact path: " + path);
        if (!path.isDirectory()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new FileSource(path, artefact));
    }

    public List<? extends ArtefactSource> getArtefactSource(Artefact artefact, int index) {
        LOG.info("Searching local repository for: " + artefact);
        File path = this.getPath(artefact, index);
        LOG.debug("Artefact path: " + path);
        if (!path.isDirectory()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new FileSource(path, artefact));
    }

    public File createArtefact(Artefact artefact) throws NativeCodeException {
        File path = this.getPath(artefact);
        LOG.info("Creating artefact: " + path);
        if (!path.mkdirs()) {
            throw new NativeCodeException("Error creating directory: " + path);
        }
        return path;
    }

    public File createArtefact(Artefact artefact, int index) throws NativeCodeException {
        File path = this.getPath(artefact, index);
        LOG.info("Creating artefact: " + path);
        if (!path.mkdirs()) {
            throw new NativeCodeException("Error creating directory: " + path);
        }
        return path;
    }
}

