/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.morph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.morph.AbstractDelegatingOperation;
import net.didion.jwnl.dictionary.morph.BaseFormSet;
import net.didion.jwnl.util.factory.Param;

public class DetachSuffixesOperation
extends AbstractDelegatingOperation {
    public static final String OPERATIONS = "operations";
    private Map _suffixMap;

    @Override
    protected AbstractDelegatingOperation getInstance(Map params) throws JWNLException {
        HashMap<POS, String[][]> suffixMap = new HashMap<POS, String[][]>();
        for (Param p : params.values()) {
            POS pos = POS.getPOSForLabel(p.getName());
            if (pos == null) continue;
            suffixMap.put(pos, this.getSuffixArray(p.getValue()));
        }
        return new DetachSuffixesOperation(suffixMap);
    }

    private String[][] getSuffixArray(String suffixes) throws JWNLException {
        StringTokenizer tokenizer = new StringTokenizer(suffixes, "|=", true);
        if (!"|".equals(tokenizer.nextToken())) {
            throw new JWNLException("DICTIONARY_EXCEPTION_028");
        }
        ArrayList<String[]> suffixList = new ArrayList<String[]>();
        while (tokenizer.hasMoreTokens()) {
            String next2 = tokenizer.nextToken();
            String first = "";
            String second = "";
            if (!"=".equals(next2)) {
                first = next2;
                tokenizer.nextToken();
            }
            if (!"|".equals(next2 = tokenizer.nextToken())) {
                second = next2;
                tokenizer.nextToken();
            }
            suffixList.add(new String[]{first, second});
        }
        return (String[][])suffixList.toArray((T[])new String[suffixList.size()][]);
    }

    public DetachSuffixesOperation() {
    }

    public DetachSuffixesOperation(Map suffixMap) {
        this._suffixMap = suffixMap;
    }

    @Override
    protected String[] getKeys() {
        return new String[]{OPERATIONS};
    }

    public Map getSuffixMap() {
        return this._suffixMap;
    }

    public void setSuffixMap(Map suffixMap) {
        this._suffixMap = suffixMap;
    }

    @Override
    public boolean execute(POS pos, String derivation, BaseFormSet forms) throws JWNLException {
        String[][] suffixArray = (String[][])this._suffixMap.get(pos);
        if (suffixArray == null) {
            return false;
        }
        boolean addedBaseForm = false;
        for (int i = 0; i < suffixArray.length; ++i) {
            String stem;
            if (!derivation.endsWith(suffixArray[i][0]) || !this.delegate(pos, stem = derivation.substring(0, derivation.length() - suffixArray[i][0].length()) + suffixArray[i][1], forms, OPERATIONS)) continue;
            addedBaseForm = true;
        }
        return addedBaseForm;
    }
}

