/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.file;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.file.DictionaryCatalog;
import net.didion.jwnl.dictionary.file.DictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;

public class DictionaryCatalogSet {
    private Map _catalogs = new HashMap();

    public DictionaryCatalogSet(String path, Class dictionaryFileType) {
        path = path.trim();
        Iterator itr = DictionaryFileType.getAllDictionaryFileTypes().iterator();
        while (itr.hasNext()) {
            DictionaryCatalog cat2 = new DictionaryCatalog(path, (DictionaryFileType)itr.next(), dictionaryFileType);
            this._catalogs.put(cat2.getKey(), cat2);
        }
    }

    public void open() throws IOException {
        if (!this.isOpen()) {
            Iterator itr = this.getCatalogIterator();
            while (itr.hasNext()) {
                ((DictionaryCatalog)itr.next()).open();
            }
        }
    }

    public boolean isOpen() {
        Iterator itr = this.getCatalogIterator();
        while (itr.hasNext()) {
            if (((DictionaryCatalog)itr.next()).isOpen()) continue;
            return false;
        }
        return true;
    }

    public void close() {
        Iterator itr = this.getCatalogIterator();
        while (itr.hasNext()) {
            ((DictionaryCatalog)itr.next()).close();
        }
    }

    public DictionaryCatalog get(DictionaryFileType fileType) {
        return (DictionaryCatalog)this._catalogs.get(fileType);
    }

    public int size() {
        return this._catalogs.size();
    }

    public Iterator getCatalogIterator() {
        return this._catalogs.values().iterator();
    }

    public DictionaryFile getDictionaryFile(POS pos, DictionaryFileType fileType) {
        return this.get(fileType).get(pos);
    }
}

