/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.database;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.dictionary.database.Query;

public class ConnectionManager {
    private String _driverClass;
    private String _url;
    private String _userName;
    private String _password;
    private boolean _registered;
    private DataSource _source = null;
    private String _jndi;

    public ConnectionManager(String driverClass, String url, String userName, String password) {
        this._driverClass = driverClass;
        this._url = url;
        this._userName = userName;
        this._password = password;
    }

    public ConnectionManager(String jndi) {
        this._jndi = jndi;
    }

    public Query getQuery(String sql) throws SQLException, JWNLException {
        return new Query(sql, this.getConnection());
    }

    public Connection getConnection() throws SQLException, JWNLException {
        if (this._jndi != null) {
            try {
                if (this._source != null) {
                    return this._source.getConnection();
                }
                InitialContext initContext = new InitialContext();
                Context envContext = (Context)initContext.lookup("java:/comp/env");
                DataSource ds = (DataSource)envContext.lookup(this._jndi);
                if (ds != null) {
                    return ds.getConnection();
                }
            }
            catch (NamingException ne) {
                throw new JWNLException("JNDI_NAMING_EXCEPTION", ne);
            }
        }
        this.registerDriver();
        if (this._userName == null) {
            return DriverManager.getConnection(this._url);
        }
        return DriverManager.getConnection(this._url, this._userName, this._password != null ? this._password : "");
    }

    private void registerDriver() throws JWNLException {
        if (!this._registered) {
            try {
                Driver driver = (Driver)Class.forName(this._driverClass).newInstance();
                DriverManager.registerDriver(driver);
                this._registered = true;
            }
            catch (Exception ex) {
                throw new JWNLException("DICTIONARY_EXCEPTION_024", ex);
            }
        }
    }
}

