/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.DictionaryElementType;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.FileDictionaryElementFactory;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.AbstractCachingDictionary;
import net.didion.jwnl.dictionary.MorphologicalProcessor;
import net.didion.jwnl.dictionary.POSKey;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.dictionary.file_manager.FileManager;
import net.didion.jwnl.util.MessageLog;
import net.didion.jwnl.util.MessageLogLevel;
import net.didion.jwnl.util.factory.Param;

public class FileBackedDictionary
extends AbstractCachingDictionary {
    private static final MessageLog _log = new MessageLog(FileBackedDictionary.class);
    public static final String MORPH = "morphological_processor";
    public static final String FILE_MANAGER = "file_manager";
    public static final String DICTIONARY_ELEMENT_FACTORY = "dictionary_element_factory";
    public static final String ENABLE_CACHING = "enable_caching";
    public static final String CACHE_SIZE = "cache_size";
    public static final String INDEX_WORD_CACHE_SIZE = "index_word_cache_size";
    public static final String SYNSET_WORD_CACHE_SIZE = "synset_word_cache_size";
    public static final String EXCEPTION_WORD_CACHE_SIZE = "exception_word_cache_size";
    private Map senseMap;
    private FileManager _db = null;
    private FileDictionaryElementFactory _factory = null;

    public static void install(FileManager fileManager, FileDictionaryElementFactory factory) {
        FileBackedDictionary.install(fileManager, null, factory);
    }

    public static void install(FileManager fileManager, MorphologicalProcessor morph, FileDictionaryElementFactory factory) {
        FileBackedDictionary.install(fileManager, morph, factory, true);
    }

    public static void install(FileManager fileManager, FileDictionaryElementFactory factory, boolean enableCaching) {
        FileBackedDictionary.install(fileManager, null, factory, enableCaching);
    }

    public static void install(FileManager fileManager, MorphologicalProcessor morph, FileDictionaryElementFactory factory, boolean enableCaching) {
        FileBackedDictionary.setDictionary(new FileBackedDictionary(fileManager, morph, factory, enableCaching));
    }

    public FileBackedDictionary() {
    }

    private FileBackedDictionary(FileManager manager, MorphologicalProcessor morph, FileDictionaryElementFactory factory, boolean enableCaching) {
        super(morph, enableCaching);
        this._db = manager;
        this._factory = factory;
        this.senseMap = new HashMap();
    }

    @Override
    public void install(Map params) throws JWNLException {
        Param param2 = (Param)params.get(MORPH);
        MorphologicalProcessor morph = param2 == null ? null : (MorphologicalProcessor)param2.create();
        FileManager manager = (FileManager)((Param)params.get(FILE_MANAGER)).create();
        FileDictionaryElementFactory factory = (FileDictionaryElementFactory)((Param)params.get(DICTIONARY_ELEMENT_FACTORY)).create();
        boolean enableCaching = !params.containsKey(ENABLE_CACHING) || !((Param)params.get(ENABLE_CACHING)).getValue().equalsIgnoreCase("false");
        FileBackedDictionary.install(manager, morph, factory, enableCaching);
        FileBackedDictionary dictionary = (FileBackedDictionary)FileBackedDictionary.getInstance();
        if (params.containsKey(CACHE_SIZE)) {
            dictionary.setCacheCapacity(Integer.parseInt(((Param)params.get(CACHE_SIZE)).getValue()));
        } else {
            if (params.containsKey(INDEX_WORD_CACHE_SIZE)) {
                dictionary.setCacheCapacity(DictionaryElementType.INDEX_WORD, Integer.parseInt(((Param)params.get(INDEX_WORD_CACHE_SIZE)).getValue()));
            }
            if (params.containsKey(SYNSET_WORD_CACHE_SIZE)) {
                dictionary.setCacheCapacity(DictionaryElementType.SYNSET, Integer.parseInt(((Param)params.get(SYNSET_WORD_CACHE_SIZE)).getValue()));
            }
            if (params.containsKey(EXCEPTION_WORD_CACHE_SIZE)) {
                dictionary.setCacheCapacity(DictionaryElementType.EXCEPTION, Integer.parseInt(((Param)params.get(EXCEPTION_WORD_CACHE_SIZE)).getValue()));
            }
        }
    }

    @Override
    public void close() {
        this._db.close();
    }

    protected FileManager getFileManager() {
        return this._db;
    }

    public FileDictionaryElementFactory getDictionaryElementFactory() {
        return this._factory;
    }

    @Override
    public Iterator getIndexWordIterator(POS pos) throws JWNLException {
        return new IndexFileLookaheadIterator(pos);
    }

    @Override
    public Iterator getIndexWordIterator(POS pos, String substring) throws JWNLException {
        return new SubstringIndexFileLookaheadIterator(pos, FileBackedDictionary.prepareQueryString(substring));
    }

    @Override
    public IndexWord getIndexWord(POS pos, String lemma) throws JWNLException {
        lemma = FileBackedDictionary.prepareQueryString(lemma);
        IndexWord word = null;
        if (lemma.length() > 0) {
            if (this.isCachingEnabled()) {
                word = this.getCachedIndexWord(new POSKey(pos, lemma));
            }
            if (word == null) {
                try {
                    long offset = this.getFileManager().getIndexedLinePointer(pos, DictionaryFileType.INDEX, lemma.replace(' ', '_'));
                    if (offset >= 0L) {
                        word = this.parseAndCacheIndexWordLine(pos, offset, this.getFileManager().readLineAt(pos, DictionaryFileType.INDEX, offset));
                    }
                }
                catch (IOException e) {
                    throw new JWNLException("DICTIONARY_EXCEPTION_004", lemma, (Throwable)e);
                }
            }
        }
        return word;
    }

    @Override
    public IndexWord getRandomIndexWord(POS pos) throws JWNLException {
        try {
            long offset = this.getFileManager().getRandomLinePointer(pos, DictionaryFileType.INDEX);
            return this.parseAndCacheIndexWordLine(pos, offset, this.getFileManager().readLineAt(pos, DictionaryFileType.INDEX, offset));
        }
        catch (IOException ex) {
            throw new JWNLException("DICTIONARY_EXCEPTION_004", ex);
        }
    }

    private IndexWord parseAndCacheIndexWordLine(POS pos, long offset, String line) {
        IndexWord word = this._factory.createIndexWord(pos, line);
        if (this.isCachingEnabled() && word != null) {
            this.cacheIndexWord(new POSKey(pos, offset), word);
        }
        return word;
    }

    @Override
    public Iterator getSynsetIterator(POS pos) {
        return new FileLookaheadIterator(pos, DictionaryFileType.DATA){

            @Override
            protected Object parseLine(POS pos, long offset, String line) {
                try {
                    return FileBackedDictionary.this.getSynset(pos, offset, line);
                }
                catch (JWNLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    @Override
    public Synset getSynsetAt(POS pos, long offset) throws JWNLException {
        return this.getSynset(pos, offset, null);
    }

    private Synset getSynset(POS pos, long offset, String line) throws JWNLException {
        POSKey key = new POSKey(pos, offset);
        Synset synset = this.getCachedSynset(key);
        if (synset == null) {
            try {
                if (line == null) {
                    line = this.getFileManager().readLineAt(pos, DictionaryFileType.DATA, offset);
                }
                synset = this._factory.createSynset(pos, line);
                synset.getWords();
                if (synset != null) {
                    this.cacheSynset(key, synset);
                }
            }
            catch (IOException e) {
                throw new JWNLException("DICTIONARY_EXCEPTION_005", new Long(offset), (Throwable)e);
            }
        }
        return synset;
    }

    @Override
    public Iterator getExceptionIterator(POS pos) {
        return new FileLookaheadIterator(pos, DictionaryFileType.EXCEPTION){

            @Override
            protected Object parseLine(POS pos, long offset, String line) {
                Exc exc = null;
                if (FileBackedDictionary.this.isCachingEnabled()) {
                    exc = FileBackedDictionary.this.getCachedException(new POSKey(pos, offset));
                }
                if (exc == null) {
                    exc = FileBackedDictionary.this.parseAndCacheExceptionLine(pos, offset, line);
                }
                return exc;
            }
        };
    }

    @Override
    public Exc getException(POS pos, String derivation) throws JWNLException {
        derivation = FileBackedDictionary.prepareQueryString(derivation);
        Exc exc = null;
        POSKey key = null;
        if (derivation != null) {
            if (this.isCachingEnabled()) {
                key = new POSKey(pos, derivation);
                exc = this.getCachedException(key);
            }
            if (exc == null) {
                long offset = -1L;
                try {
                    offset = this.getFileManager().getIndexedLinePointer(pos, DictionaryFileType.EXCEPTION, derivation.replace(' ', '_'));
                    if (offset >= 0L) {
                        exc = this.parseAndCacheExceptionLine(pos, offset, this.getFileManager().readLineAt(pos, DictionaryFileType.EXCEPTION, offset));
                    }
                }
                catch (IOException ex) {
                    throw new JWNLException("DICTIONARY_EXCEPTION_006", ex);
                }
            }
        }
        return exc;
    }

    private Exc parseAndCacheExceptionLine(POS pos, long offset, String line) {
        Exc exc = this._factory.createExc(pos, line);
        if (this.isCachingEnabled() && exc != null) {
            this.cacheException(new POSKey(pos, offset), exc);
        }
        return exc;
    }

    private class SubstringIndexFileLookaheadIterator
    extends IndexFileLookaheadIterator {
        private String _substring;

        public SubstringIndexFileLookaheadIterator(POS pos, String substring) throws JWNLException {
            super(pos);
            this._substring = null;
            this._substring = substring;
            this.nextOffset();
        }

        @Override
        protected long getNextOffset(long currentOffset) throws JWNLException {
            try {
                return FileBackedDictionary.this.getFileManager().getMatchingLinePointer(this._pos, DictionaryFileType.INDEX, currentOffset, this._substring);
            }
            catch (IOException ex) {
                throw new JWNLException("DICTIONARY_EXCEPTION_008", new Object[]{this._pos, this._fileType}, (Throwable)ex);
            }
        }
    }

    private class IndexFileLookaheadIterator
    extends FileLookaheadIterator {
        public IndexFileLookaheadIterator(POS pos) {
            super(pos, DictionaryFileType.INDEX);
        }

        @Override
        protected Object parseLine(POS pos, long offset, String line) {
            IndexWord word = null;
            if (FileBackedDictionary.this.isCachingEnabled()) {
                word = FileBackedDictionary.this.getCachedIndexWord(new POSKey(this._pos, offset));
            }
            if (word == null) {
                word = FileBackedDictionary.this.parseAndCacheIndexWordLine(this._pos, offset, line);
            }
            return word;
        }
    }

    private abstract class FileLookaheadIterator
    implements Iterator {
        private String _currentLine = null;
        private long _currentOffset = -1L;
        private long _nextOffset = 0L;
        private boolean _more = true;
        protected POS _pos;
        protected DictionaryFileType _fileType;

        public FileLookaheadIterator(POS pos, DictionaryFileType fileType) {
            this._pos = pos;
            this._fileType = fileType;
            try {
                this._nextOffset = FileBackedDictionary.this._db.getFirstLinePointer(pos, fileType);
                this.nextLine();
            }
            catch (IOException ex) {
                _log.log(MessageLogLevel.WARN, "DICTIONARY_EXCEPTION_007", new Object[]{this._pos, this._fileType});
            }
        }

        protected abstract Object parseLine(POS var1, long var2, String var4);

        public final Object next() {
            if (this.hasNext()) {
                Object returnVal = this.parseLine(this._pos, this._currentOffset, this._currentLine);
                this.nextLine();
                return returnVal;
            }
            throw new NoSuchElementException();
        }

        @Override
        public final boolean hasNext() {
            return this._more;
        }

        @Override
        public void remove() {
        }

        protected final void nextLine() {
            try {
                this._currentLine = FileBackedDictionary.this._db.readLineAt(this._pos, this._fileType, this._nextOffset);
                if (this._currentLine != null) {
                    this.nextOffset();
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._more = false;
        }

        protected final void nextOffset() throws JWNLException {
            this._currentOffset = this._nextOffset;
            this._nextOffset = this.getNextOffset(this._currentOffset);
        }

        protected long getNextOffset(long currentOffset) throws JWNLException {
            try {
                return FileBackedDictionary.this._db.getNextLinePointer(this._pos, this._fileType, currentOffset);
            }
            catch (IOException ex) {
                throw new JWNLException("DICTIONARY_EXCEPTION_008", new Object[]{this._pos, this._fileType}, (Throwable)ex);
            }
        }
    }
}

