/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data.relationship;

import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.data.relationship.Relationship;

public class AsymmetricRelationship
extends Relationship {
    private int _commonParentIndex;
    private transient int _cachedRelativeTargetDepth = -1;

    public AsymmetricRelationship(PointerType type, PointerTargetNodeList nodes, int commonParentIndex, Synset sourceSynset, Synset targetSynset) {
        super(type, nodes, sourceSynset, targetSynset);
        this._commonParentIndex = commonParentIndex;
    }

    public int getCommonParentIndex() {
        return this._commonParentIndex;
    }

    public int getRelativeTargetDepth() {
        if (this._cachedRelativeTargetDepth == -1) {
            int distSourceToParent = this._commonParentIndex;
            int distParentToTarget = this.getNodeList().size() - 1 - this._commonParentIndex;
            this._cachedRelativeTargetDepth = distParentToTarget - distSourceToParent;
        }
        return this._cachedRelativeTargetDepth;
    }

    @Override
    public Relationship reverse() {
        PointerTargetNodeList list2 = ((PointerTargetNodeList)this.getNodeList().deepClone()).reverse();
        int commonParentIndex = list2.size() - 1 - this.getCommonParentIndex();
        for (int i = 0; i < list2.size(); ++i) {
            if (i == commonParentIndex) continue;
            ((PointerTargetNode)list2.get(i)).setType(this.getType().getSymmetricType());
        }
        return new AsymmetricRelationship(this.getType(), list2, commonParentIndex, this.getSourceSynset(), this.getTargetSynset());
    }
}

